# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_credentials200_response_all_of_credential_config import AddCredentials200ResponseAllOfCredentialConfig
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_credentials200_response_all_of_credentials_inner_user import ListCredentials200ResponseAllOfCredentialsInnerUser
from typing import Optional, Set
from typing_extensions import Self

class AddCredentials200ResponseAllOfCredential(BaseModel):
    """
    AddCredentials200ResponseAllOfCredential
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    integration: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    username: Optional[StrictStr] = None
    password: Optional[StrictStr] = None
    password_hash: Optional[StrictStr] = Field(default=None, alias="passwordHash")
    auth_key: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="authKey")
    auth_path: Optional[StrictStr] = Field(default=None, alias="authPath")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictStr] = Field(default=None, alias="refId")
    category: Optional[StrictStr] = None
    scope: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    enabled: Optional[StrictBool] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    user: Optional[ListCredentials200ResponseAllOfCredentialsInnerUser] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    config: Optional[AddCredentials200ResponseAllOfCredentialConfig] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "type", "integration", "description", "username", "password", "passwordHash", "authKey", "authPath", "externalId", "refType", "refId", "category", "scope", "status", "statusMessage", "statusDate", "enabled", "account", "user", "dateCreated", "lastUpdated", "config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddCredentials200ResponseAllOfCredential from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auth_key
        if self.auth_key:
            _dict['authKey'] = self.auth_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if integration (nullable) is None
        # and model_fields_set contains the field
        if self.integration is None and "integration" in self.model_fields_set:
            _dict['integration'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict['password'] = None

        # set to None if password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.password_hash is None and "password_hash" in self.model_fields_set:
            _dict['passwordHash'] = None

        # set to None if auth_path (nullable) is None
        # and model_fields_set contains the field
        if self.auth_path is None and "auth_path" in self.model_fields_set:
            _dict['authPath'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if status_date (nullable) is None
        # and model_fields_set contains the field
        if self.status_date is None and "status_date" in self.model_fields_set:
            _dict['statusDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddCredentials200ResponseAllOfCredential from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "integration": obj.get("integration"),
            "description": obj.get("description"),
            "username": obj.get("username"),
            "password": obj.get("password"),
            "passwordHash": obj.get("passwordHash"),
            "authKey": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["authKey"]) if obj.get("authKey") is not None else None,
            "authPath": obj.get("authPath"),
            "externalId": obj.get("externalId"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "category": obj.get("category"),
            "scope": obj.get("scope"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "statusDate": obj.get("statusDate"),
            "enabled": obj.get("enabled"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "user": ListCredentials200ResponseAllOfCredentialsInnerUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "config": AddCredentials200ResponseAllOfCredentialConfig.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


