# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_clouds200_response_all_of_zones_inner_config_any_of_network_server import ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_config_plan import ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan
from typing import Optional, Set
from typing_extensions import Self

class AddImageBuild200ResponseAllOfImageBuildConfigInstance(BaseModel):
    """
    AddImageBuild200ResponseAllOfImageBuildConfigInstance
    """ # noqa: E501
    layout: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan] = None
    type: Optional[StrictStr] = None
    user_group: Optional[ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer] = Field(default=None, alias="userGroup")
    __properties: ClassVar[List[str]] = ["layout", "type", "userGroup"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddImageBuild200ResponseAllOfImageBuildConfigInstance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of layout
        if self.layout:
            _dict['layout'] = self.layout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_group
        if self.user_group:
            _dict['userGroup'] = self.user_group.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddImageBuild200ResponseAllOfImageBuildConfigInstance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "layout": ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan.from_dict(obj["layout"]) if obj.get("layout") is not None else None,
            "type": obj.get("type"),
            "userGroup": ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer.from_dict(obj["userGroup"]) if obj.get("userGroup") is not None else None
        })
        return _obj


