# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AddInstanceDeployRequestAppDeploy(BaseModel):
    """
    AddInstanceDeployRequestAppDeploy
    """ # noqa: E501
    deployment_id: Optional[StrictInt] = Field(default=None, description="Deployment ID.", alias="deploymentId")
    version: Optional[StrictStr] = Field(default=None, description="Deployment Version number identifier (userVersion). Can be passed along with deploymentId to identify the version")
    version_id: Optional[StrictInt] = Field(default=None, description="Deployment Version ID. This can be passed instead of deploymentId and version.", alias="versionId")
    config: Optional[Dict[str, Any]] = Field(default=None, description="Map of configuration properties that vary by instance type.")
    stage_only: Optional[StrictBool] = Field(default=False, description="Stage Only, do not run the deploy right away and instead set status to staged so it can be deployed later on.", alias="stageOnly")
    __properties: ClassVar[List[str]] = ["deploymentId", "version", "versionId", "config", "stageOnly"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddInstanceDeployRequestAppDeploy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddInstanceDeployRequestAppDeploy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deploymentId": obj.get("deploymentId"),
            "version": obj.get("version"),
            "versionId": obj.get("versionId"),
            "config": obj.get("config"),
            "stageOnly": obj.get("stageOnly") if obj.get("stageOnly") is not None else False
        })
        return _obj


