# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_cluster_layouts_request_layout_environment_variables_inner import AddClusterLayoutsRequestLayoutEnvironmentVariablesInner
from morpheus.models.add_instance_type_request_instance_type_price_sets_inner import AddInstanceTypeRequestInstanceTypePriceSetsInner
from typing import Optional, Set
from typing_extensions import Self

class AddInstanceTypeRequestInstanceType(BaseModel):
    """
    AddInstanceTypeRequestInstanceType
    """ # noqa: E501
    name: StrictStr = Field(description="Instance type name")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    description: Optional[StrictStr] = Field(default=None, description="Instance type description")
    code: Optional[StrictStr] = Field(default=None, description="Instance type code")
    category: Optional[StrictStr] = Field(default=None, description="Category")
    visibility: Optional[StrictStr] = Field(default='private', description="Visibility")
    featured: Optional[StrictBool] = Field(default=None, description="Featured")
    has_settings: Optional[StrictBool] = Field(default=None, description="Enable Settings", alias="hasSettings")
    has_auto_scale: Optional[StrictBool] = Field(default=None, description="Enable Scaling (Horizontal)", alias="hasAutoScale")
    has_deployment: Optional[StrictBool] = Field(default=None, description="Supports Deployments", alias="hasDeployment")
    environment_prefix: Optional[StrictStr] = Field(default=None, description="Environment Prefix, can be used to make exported evars unique.", alias="environmentPrefix")
    environment_variables: Optional[List[AddClusterLayoutsRequestLayoutEnvironmentVariablesInner]] = Field(default=None, description="Array of instance type env variables.", alias="environmentVariables")
    price_sets: Optional[List[AddInstanceTypeRequestInstanceTypePriceSetsInner]] = Field(default=None, description="Array of price set objects", alias="priceSets")
    option_types: Optional[List[StrictInt]] = Field(default=None, description="Array of instance type option type IDs", alias="optionTypes")
    __properties: ClassVar[List[str]] = ["name", "labels", "description", "code", "category", "visibility", "featured", "hasSettings", "hasAutoScale", "hasDeployment", "environmentPrefix", "environmentVariables", "priceSets", "optionTypes"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['private', 'public']):
            raise ValueError("must be one of enum values ('private', 'public')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddInstanceTypeRequestInstanceType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in environment_variables (list)
        _items = []
        if self.environment_variables:
            for _item_environment_variables in self.environment_variables:
                if _item_environment_variables:
                    _items.append(_item_environment_variables.to_dict())
            _dict['environmentVariables'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in price_sets (list)
        _items = []
        if self.price_sets:
            for _item_price_sets in self.price_sets:
                if _item_price_sets:
                    _items.append(_item_price_sets.to_dict())
            _dict['priceSets'] = _items
        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddInstanceTypeRequestInstanceType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "description": obj.get("description"),
            "code": obj.get("code"),
            "category": obj.get("category"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "featured": obj.get("featured"),
            "hasSettings": obj.get("hasSettings"),
            "hasAutoScale": obj.get("hasAutoScale"),
            "hasDeployment": obj.get("hasDeployment"),
            "environmentPrefix": obj.get("environmentPrefix"),
            "environmentVariables": [AddClusterLayoutsRequestLayoutEnvironmentVariablesInner.from_dict(_item) for _item in obj["environmentVariables"]] if obj.get("environmentVariables") is not None else None,
            "priceSets": [AddInstanceTypeRequestInstanceTypePriceSetsInner.from_dict(_item) for _item in obj["priceSets"]] if obj.get("priceSets") is not None else None,
            "optionTypes": obj.get("optionTypes")
        })
        return _obj


