# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_policies_request_policy_config import AddPoliciesRequestPolicyConfig
from morpheus.models.add_policies_request_policy_policy_type import AddPoliciesRequestPolicyPolicyType
from typing import Optional, Set
from typing_extensions import Self

class AddPoliciesRequestPolicy(BaseModel):
    """
    AddPoliciesRequestPolicy
    """ # noqa: E501
    name: StrictStr = Field(description="A name for the policy")
    description: Optional[StrictStr] = Field(default=None, description="A description for the policy")
    policy_type: AddPoliciesRequestPolicyPolicyType = Field(alias="policyType")
    config: AddPoliciesRequestPolicyConfig
    enabled: Optional[StrictBool] = Field(default=True, description="Set to false to disable")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, description="Scope object ID (`group`,`cloud`,`user`, etc)", alias="refId")
    accounts: Optional[List[StrictInt]] = Field(default=None, description="Array of tenants to scope the policy to")
    each_user: Optional[StrictBool] = Field(default=None, description="Apply individually to each user in role.  Only when `refType` equals `Role`", alias="eachUser")
    __properties: ClassVar[List[str]] = ["name", "description", "policyType", "config", "enabled", "refType", "refId", "accounts", "eachUser"]

    @field_validator('ref_type')
    def ref_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ComputeSite', 'ComputeZone', 'User', 'Role', 'Network', 'Plan']):
            raise ValueError("must be one of enum values ('ComputeSite', 'ComputeZone', 'User', 'Role', 'Network', 'Plan')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddPoliciesRequestPolicy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of policy_type
        if self.policy_type:
            _dict['policyType'] = self.policy_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddPoliciesRequestPolicy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "policyType": AddPoliciesRequestPolicyPolicyType.from_dict(obj["policyType"]) if obj.get("policyType") is not None else None,
            "config": AddPoliciesRequestPolicyConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "accounts": obj.get("accounts"),
            "eachUser": obj.get("eachUser")
        })
        return _obj


