# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AddPowerSchedulesRequestSchedule(BaseModel):
    """
    AddPowerSchedulesRequestSchedule
    """ # noqa: E501
    name: StrictStr = Field(description="A name for the power schedule")
    description: Optional[StrictStr] = Field(default=None, description="A description for the power schedule")
    schedule_type: Optional[StrictStr] = Field(default=None, description="Type of schedule `power` on or `power off`", alias="scheduleType")
    schedule_timezone: Optional[StrictStr] = Field(default='UTC', description="Time Zone eg. America/New_York, Europe/Amsterdam, etc.", alias="scheduleTimezone")
    enabled: Optional[StrictBool] = Field(default=True, description="Is the power schedule enabled")
    monday_on_time: Optional[StrictStr] = Field(default='00:00', description="Monday Start time of the day in 24-hour format", alias="mondayOnTime")
    monday_off_time: Optional[StrictStr] = Field(default='24:00', description="Monday Off time of the day in 24-hour format", alias="mondayOffTime")
    tuesday_on_time: Optional[StrictStr] = Field(default='00:00', description="Tuesday Start time of the day in 24-hour format", alias="tuesdayOnTime")
    tuesday_off_time: Optional[StrictStr] = Field(default='24:00', description="Tuesday Off time of the day in 24-hour format", alias="tuesdayOffTime")
    wednesday_on_time: Optional[StrictStr] = Field(default='00:00', description="Wednesday Start time of the day in 24-hour format", alias="wednesdayOnTime")
    wednesday_off_time: Optional[StrictStr] = Field(default='24:00', description="Wednesday Off time of the day in 24-hour format", alias="wednesdayOffTime")
    thursday_on_time: Optional[StrictStr] = Field(default='00:00', description="Thursday Start time of the day in 24-hour format", alias="thursdayOnTime")
    thursday_off_time: Optional[StrictStr] = Field(default='24:00', description="Thursday Off time of the day in 24-hour format", alias="thursdayOffTime")
    friday_on_time: Optional[StrictStr] = Field(default='00:00', description="Friday Start time of the day in 24-hour format", alias="fridayOnTime")
    friday_off_time: Optional[StrictStr] = Field(default='24:00', description="Friday Off time of the day in 24-hour format", alias="fridayOffTime")
    saturday_on_time: Optional[StrictStr] = Field(default='00:00', description="Saturday Start time of the day in 24-hour format", alias="saturdayOnTime")
    saturday_off_time: Optional[StrictStr] = Field(default='24:00', description="Saturday Off time of the day in 24-hour format", alias="saturdayOffTime")
    sunday_on_time: Optional[StrictStr] = Field(default='00:00', description="Sunday Start time of the day in 24-hour format", alias="sundayOnTime")
    sunday_off_time: Optional[StrictStr] = Field(default='24:00', description="Sunday Off time of the day in 24-hour format", alias="sundayOffTime")
    __properties: ClassVar[List[str]] = ["name", "description", "scheduleType", "scheduleTimezone", "enabled", "mondayOnTime", "mondayOffTime", "tuesdayOnTime", "tuesdayOffTime", "wednesdayOnTime", "wednesdayOffTime", "thursdayOnTime", "thursdayOffTime", "fridayOnTime", "fridayOffTime", "saturdayOnTime", "saturdayOffTime", "sundayOnTime", "sundayOffTime"]

    @field_validator('schedule_type')
    def schedule_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['power', 'power off']):
            raise ValueError("must be one of enum values ('power', 'power off')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddPowerSchedulesRequestSchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddPowerSchedulesRequestSchedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "scheduleType": obj.get("scheduleType"),
            "scheduleTimezone": obj.get("scheduleTimezone") if obj.get("scheduleTimezone") is not None else 'UTC',
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "mondayOnTime": obj.get("mondayOnTime") if obj.get("mondayOnTime") is not None else '00:00',
            "mondayOffTime": obj.get("mondayOffTime") if obj.get("mondayOffTime") is not None else '24:00',
            "tuesdayOnTime": obj.get("tuesdayOnTime") if obj.get("tuesdayOnTime") is not None else '00:00',
            "tuesdayOffTime": obj.get("tuesdayOffTime") if obj.get("tuesdayOffTime") is not None else '24:00',
            "wednesdayOnTime": obj.get("wednesdayOnTime") if obj.get("wednesdayOnTime") is not None else '00:00',
            "wednesdayOffTime": obj.get("wednesdayOffTime") if obj.get("wednesdayOffTime") is not None else '24:00',
            "thursdayOnTime": obj.get("thursdayOnTime") if obj.get("thursdayOnTime") is not None else '00:00',
            "thursdayOffTime": obj.get("thursdayOffTime") if obj.get("thursdayOffTime") is not None else '24:00',
            "fridayOnTime": obj.get("fridayOnTime") if obj.get("fridayOnTime") is not None else '00:00',
            "fridayOffTime": obj.get("fridayOffTime") if obj.get("fridayOffTime") is not None else '24:00',
            "saturdayOnTime": obj.get("saturdayOnTime") if obj.get("saturdayOnTime") is not None else '00:00',
            "saturdayOffTime": obj.get("saturdayOffTime") if obj.get("saturdayOffTime") is not None else '24:00',
            "sundayOnTime": obj.get("sundayOnTime") if obj.get("sundayOnTime") is not None else '00:00',
            "sundayOffTime": obj.get("sundayOffTime") if obj.get("sundayOffTime") is not None else '24:00'
        })
        return _obj


