# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_service_plans_request_service_plan_config_ranges import AddServicePlansRequestServicePlanConfigRanges
from typing import Optional, Set
from typing_extensions import Self

class AddServicePlansRequestServicePlanConfig(BaseModel):
    """
    AddServicePlansRequestServicePlanConfig
    """ # noqa: E501
    storage_size_type: Optional[StrictStr] = Field(default='gb', description="Specifies range min / max storage multiplier", alias="storageSizeType")
    memory_size_type: Optional[StrictStr] = Field(default='mb', description="Specifies range min / max memory multiplier", alias="memorySizeType")
    ranges: Optional[AddServicePlansRequestServicePlanConfigRanges] = None
    __properties: ClassVar[List[str]] = ["storageSizeType", "memorySizeType", "ranges"]

    @field_validator('storage_size_type')
    def storage_size_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['gb', 'mb']):
            raise ValueError("must be one of enum values ('gb', 'mb')")
        return value

    @field_validator('memory_size_type')
    def memory_size_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['gb', 'mb']):
            raise ValueError("must be one of enum values ('gb', 'mb')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddServicePlansRequestServicePlanConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ranges
        if self.ranges:
            _dict['ranges'] = self.ranges.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddServicePlansRequestServicePlanConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "storageSizeType": obj.get("storageSizeType") if obj.get("storageSizeType") is not None else 'gb',
            "memorySizeType": obj.get("memorySizeType") if obj.get("memorySizeType") is not None else 'mb',
            "ranges": AddServicePlansRequestServicePlanConfigRanges.from_dict(obj["ranges"]) if obj.get("ranges") is not None else None
        })
        return _obj


