# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, SecretStr, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class AddUserTenantRequestUser(BaseModel):
    """
    Payload for creating a new user
    """ # noqa: E501
    first_name: Optional[StrictStr] = Field(default=None, description="The user's first name (optional)", alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, description="The user's last name (optional)", alias="lastName")
    username: StrictStr = Field(description="Username (unique per tenant).")
    email: StrictStr = Field(description="Email address")
    password: SecretStr = Field(description="Password to apply to the user")
    roles: List[GetAlerts200ResponseAllOfChecksInnerAccount] = Field(description="Array of objects with id of the role(s) to assign to the user.")
    receive_notifications: Optional[StrictBool] = Field(default=True, description="Receive Notifications?", alias="receiveNotifications")
    linux_username: Optional[StrictStr] = Field(default=None, description="Linux Username, user settings for provisioning", alias="linuxUsername")
    linux_password: Optional[StrictStr] = Field(default=None, description="Linux Password, user settings for provisioning", alias="linuxPassword")
    linux_key_pair_id: Optional[StrictInt] = Field(default=None, description="Linux SSH Key, user settings for provisioning", alias="linuxKeyPairId")
    windows_username: Optional[StrictStr] = Field(default=None, description="Windows Username, user settings for provisioning", alias="windowsUsername")
    windows_password: Optional[StrictStr] = Field(default=None, description="Windows Password, user settings for provisioning", alias="windowsPassword")
    __properties: ClassVar[List[str]] = ["firstName", "lastName", "username", "email", "password", "roles", "receiveNotifications", "linuxUsername", "linuxPassword", "linuxKeyPairId", "windowsUsername", "windowsPassword"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddUserTenantRequestUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in roles (list)
        _items = []
        if self.roles:
            for _item_roles in self.roles:
                if _item_roles:
                    _items.append(_item_roles.to_dict())
            _dict['roles'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddUserTenantRequestUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "password": obj.get("password"),
            "roles": [GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(_item) for _item in obj["roles"]] if obj.get("roles") is not None else None,
            "receiveNotifications": obj.get("receiveNotifications") if obj.get("receiveNotifications") is not None else True,
            "linuxUsername": obj.get("linuxUsername"),
            "linuxPassword": obj.get("linuxPassword"),
            "linuxKeyPairId": obj.get("linuxKeyPairId"),
            "windowsUsername": obj.get("windowsUsername"),
            "windowsPassword": obj.get("windowsPassword")
        })
        return _obj


