# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AmazonInstanceConfiguration(BaseModel):
    """
    AmazonInstanceConfiguration
    """ # noqa: E501
    no_agent: Optional[StrictBool] = Field(default=False, description="Skipping Agent installation will result in a lack of logging and guest operating system statistics. Automation scripts may also be adversely affected.", alias="noAgent")
    is_ec2: Optional[StrictStr] = Field(default='false', description="Amazon Cloud Type", alias="isEC2")
    availability_id: Optional[StrictStr] = Field(default=None, description="Amazon Zone", alias="availabilityId")
    security_id: Optional[StrictStr] = Field(default=None, description="Security Group", alias="securityId")
    public_ip_type: Optional[StrictStr] = Field(default=None, description="Public IP", alias="publicIpType")
    instance_profile: Optional[StrictStr] = Field(default=None, description="IAM Profile", alias="instanceProfile")
    kms_key_id: Optional[StrictStr] = Field(default=None, description="KMS Key ID", alias="kmsKeyId")
    __properties: ClassVar[List[str]] = ["noAgent", "isEC2", "availabilityId", "securityId", "publicIpType", "instanceProfile", "kmsKeyId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AmazonInstanceConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if no_agent (nullable) is None
        # and model_fields_set contains the field
        if self.no_agent is None and "no_agent" in self.model_fields_set:
            _dict['noAgent'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AmazonInstanceConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "noAgent": obj.get("noAgent") if obj.get("noAgent") is not None else False,
            "isEC2": obj.get("isEC2") if obj.get("isEC2") is not None else 'false',
            "availabilityId": obj.get("availabilityId"),
            "securityId": obj.get("securityId"),
            "publicIpType": obj.get("publicIpType"),
            "instanceProfile": obj.get("instanceProfile"),
            "kmsKeyId": obj.get("kmsKeyId")
        })
        return _obj


