# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ApplianceSettingsUpdate(BaseModel):
    """
    ApplianceSettingsUpdate
    """ # noqa: E501
    appliance_url: Optional[StrictStr] = Field(default=None, description="Appliance URL", alias="applianceUrl")
    internal_appliance_url: Optional[StrictStr] = Field(default=None, description="Internal Appliance URL (PXE)", alias="internalApplianceUrl")
    cors_allowed: Optional[StrictStr] = Field(default=None, description="API Allowed Origins", alias="corsAllowed")
    registration_enabled: Optional[StrictBool] = Field(default=None, description="Registration enabled (true, false)", alias="registrationEnabled")
    default_role_id: Optional[StrictInt] = Field(default=None, description="Default tenant role ID", alias="defaultRoleId")
    default_user_role_id: Optional[StrictInt] = Field(default=None, description="Default user role ID", alias="defaultUserRoleId")
    docker_privileged_mode: Optional[StrictBool] = Field(default=None, description="Docker privileged mode (true, false)", alias="dockerPrivilegedMode")
    password_min_length: Optional[StrictStr] = Field(default=None, description="Min Password Length", alias="passwordMinLength")
    password_min_upper_case: Optional[StrictStr] = Field(default=None, description="Min Password Uppercase", alias="passwordMinUpperCase")
    password_min_numbers: Optional[StrictStr] = Field(default=None, description="Min Password Numbers", alias="passwordMinNumbers")
    password_min_symbols: Optional[StrictStr] = Field(default=None, description="Min Password Symbols", alias="passwordMinSymbols")
    user_browser_session_timeout: Optional[StrictStr] = Field(default=None, description="User Browser Session Timeout (Minutes)", alias="userBrowserSessionTimeout")
    user_browser_session_warning: Optional[StrictStr] = Field(default=None, description="User Browser Session Warning (Minutes)", alias="userBrowserSessionWarning")
    expire_pwd_days: Optional[StrictInt] = Field(default=None, description="Expire password after days. Setting to 0 disabled this feature", alias="expirePwdDays")
    disable_after_attempts: Optional[StrictInt] = Field(default=None, description="Disable user after number of attempts. Set to 0 to disable this feature", alias="disableAfterAttempts")
    disable_after_days_inactive: Optional[StrictInt] = Field(default=None, description="Disable user if inactive for specified days. Set to 0 to disable this feature", alias="disableAfterDaysInactive")
    warn_user_days_before: Optional[StrictInt] = Field(default=None, description="Send warning email number of days in advance before deactivating. Set to 0 to disable this feature", alias="warnUserDaysBefore")
    smtp_mail_from: Optional[StrictStr] = Field(default=None, description="From email address", alias="smtpMailFrom")
    smtp_server: Optional[StrictStr] = Field(default=None, description="SMTP server / host", alias="smtpServer")
    smtp_port: Optional[StrictInt] = Field(default=None, description="SMTP port", alias="smtpPort")
    smtp_ssl: Optional[StrictBool] = Field(default=None, description="Use SSL for SMTP connection", alias="smtpSSL")
    smtp_tls: Optional[StrictBool] = Field(default=None, description="Use TLS for SMTP connections", alias="smtpTLS")
    smtp_user: Optional[StrictStr] = Field(default=None, description="SMTP username", alias="smtpUser")
    smtp_password: Optional[StrictStr] = Field(default=None, description="SMTP password", alias="smtpPassword")
    proxy_host: Optional[StrictStr] = Field(default=None, description="Proxy host", alias="proxyHost")
    proxy_port: Optional[StrictStr] = Field(default=None, description="Proxy port", alias="proxyPort")
    proxy_user: Optional[StrictStr] = Field(default=None, description="Proxy username", alias="proxyUser")
    proxy_password: Optional[StrictStr] = Field(default=None, description="Proxy password", alias="proxyPassword")
    proxy_domain: Optional[StrictStr] = Field(default=None, description="Proxy domain", alias="proxyDomain")
    proxy_workstation: Optional[StrictStr] = Field(default=None, description="Proxy workstation", alias="proxyWorkstation")
    currency_provider: Optional[StrictStr] = Field(default=None, description="Currency provider", alias="currencyProvider")
    currency_key: Optional[StrictStr] = Field(default=None, description="Currency provider API key", alias="currencyKey")
    enable_all_zone_types: Optional[StrictBool] = Field(default=None, description="Set all cloud types enabled status on, overrides enableZoneTypes and disableZoneTypes parameters", alias="enableAllZoneTypes")
    enable_zone_types: Optional[List[StrictInt]] = Field(default=None, description="List of cloud type IDs to set enabled status on", alias="enableZoneTypes")
    disable_zone_types: Optional[List[StrictInt]] = Field(default=None, description="List of cloud type IDs to set enabled status off", alias="disableZoneTypes")
    disable_all_zone_types: Optional[StrictBool] = Field(default=None, description="Set all cloud types enabled status off, can be used in conjunction with enableZoneTypes", alias="disableAllZoneTypes")
    twilio_account_sid: Optional[StrictStr] = Field(default=None, description="Twilio SMS Account SID", alias="twilioAccountSid")
    twilio_sms_from: Optional[StrictStr] = Field(default=None, description="Twilio SMS From", alias="twilioSmsFrom")
    twilio_auth_token: Optional[StrictStr] = Field(default=None, description="Twilio SMS Auth Token", alias="twilioAuthToken")
    cloud_sync_interval_seconds: Optional[StrictInt] = Field(default=None, description="Cloud Sync Interval (Seconds)", alias="cloudSyncIntervalSeconds")
    cluster_sync_interval_seconds: Optional[StrictInt] = Field(default=None, description="Cluster Sync Interval (Seconds)", alias="clusterSyncIntervalSeconds")
    usage_retainment_period: Optional[StrictInt] = Field(default=None, description="Usage Retainment (Days)", alias="usageRetainmentPeriod")
    invoice_retainment_period: Optional[StrictInt] = Field(default=None, description="Invoice Retainment (Days)", alias="invoiceRetainmentPeriod")
    incident_retainment_period: Optional[StrictInt] = Field(default=None, description="Incident Retainment (Days)", alias="incidentRetainmentPeriod")
    stats_retainment_period: Optional[StrictInt] = Field(default=None, description="The number of days stats will be retained. (30, 60 or 90)", alias="statsRetainmentPeriod")
    reports_retainment_period: Optional[StrictInt] = Field(default=None, description="The number of days reports will be retained.", alias="reportsRetainmentPeriod")
    http_blacklist_hosts: Optional[StrictStr] = Field(default=None, description="Provide a comma delimited list of ips/hostnames to be blocked when using HTTP Task Types or REST Datasource Option Lists", alias="httpBlacklistHosts")
    http_approvelist_hosts: Optional[StrictStr] = Field(default=None, description="Provide a comma delimited list of ips/hostnames to be allowed when using HTTP Task Types or REST Datasource Option Lists. If not specified, only deny list is filtered out.", alias="httpApprovelistHosts")
    no_agent: Optional[StrictBool] = Field(default=None, description="If true, disables Agent installation globally.", alias="noAgent")
    agent_ssl_verify: Optional[StrictBool] = Field(default=None, description="Enable/Disable SSL Verification of Agent", alias="agentSSLVerify")
    disable_ssh_password_auth: Optional[StrictBool] = Field(default=None, description="Enable/Disable SSH Password Authentication for the Appliance", alias="disableSSHPasswordAuth")
    default_locale: Optional[StrictStr] = Field(default=None, description="Default appliance Locale. Setting a default locale for the application will override user browser preferences.", alias="defaultLocale")
    default_vdi_gateway: Optional[StrictInt] = Field(default=None, description="ID of the VDI gateway.", alias="defaultVdiGateway")
    max_option_list_size: Optional[StrictInt] = Field(default=None, description="Max option list size. Units are x10^3 (thousand). Increasing this value can adversely affect Morpheus performance. Increase with caution.", alias="maxOptionListSize")
    exchange_url: Optional[StrictStr] = Field(default=None, description="The url used for checking if there is an update for plugins. Default https\\://share.morpheusdata.com", alias="exchangeUrl")
    __properties: ClassVar[List[str]] = ["applianceUrl", "internalApplianceUrl", "corsAllowed", "registrationEnabled", "defaultRoleId", "defaultUserRoleId", "dockerPrivilegedMode", "passwordMinLength", "passwordMinUpperCase", "passwordMinNumbers", "passwordMinSymbols", "userBrowserSessionTimeout", "userBrowserSessionWarning", "expirePwdDays", "disableAfterAttempts", "disableAfterDaysInactive", "warnUserDaysBefore", "smtpMailFrom", "smtpServer", "smtpPort", "smtpSSL", "smtpTLS", "smtpUser", "smtpPassword", "proxyHost", "proxyPort", "proxyUser", "proxyPassword", "proxyDomain", "proxyWorkstation", "currencyProvider", "currencyKey", "enableAllZoneTypes", "enableZoneTypes", "disableZoneTypes", "disableAllZoneTypes", "twilioAccountSid", "twilioSmsFrom", "twilioAuthToken", "cloudSyncIntervalSeconds", "clusterSyncIntervalSeconds", "usageRetainmentPeriod", "invoiceRetainmentPeriod", "incidentRetainmentPeriod", "statsRetainmentPeriod", "reportsRetainmentPeriod", "httpBlacklistHosts", "httpApprovelistHosts", "noAgent", "agentSSLVerify", "disableSSHPasswordAuth", "defaultLocale", "defaultVdiGateway", "maxOptionListSize", "exchangeUrl"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplianceSettingsUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if internal_appliance_url (nullable) is None
        # and model_fields_set contains the field
        if self.internal_appliance_url is None and "internal_appliance_url" in self.model_fields_set:
            _dict['internalApplianceUrl'] = None

        # set to None if cors_allowed (nullable) is None
        # and model_fields_set contains the field
        if self.cors_allowed is None and "cors_allowed" in self.model_fields_set:
            _dict['corsAllowed'] = None

        # set to None if proxy_host (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_host is None and "proxy_host" in self.model_fields_set:
            _dict['proxyHost'] = None

        # set to None if proxy_port (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_port is None and "proxy_port" in self.model_fields_set:
            _dict['proxyPort'] = None

        # set to None if proxy_domain (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_domain is None and "proxy_domain" in self.model_fields_set:
            _dict['proxyDomain'] = None

        # set to None if proxy_workstation (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_workstation is None and "proxy_workstation" in self.model_fields_set:
            _dict['proxyWorkstation'] = None

        # set to None if currency_key (nullable) is None
        # and model_fields_set contains the field
        if self.currency_key is None and "currency_key" in self.model_fields_set:
            _dict['currencyKey'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplianceSettingsUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applianceUrl": obj.get("applianceUrl"),
            "internalApplianceUrl": obj.get("internalApplianceUrl"),
            "corsAllowed": obj.get("corsAllowed"),
            "registrationEnabled": obj.get("registrationEnabled"),
            "defaultRoleId": obj.get("defaultRoleId"),
            "defaultUserRoleId": obj.get("defaultUserRoleId"),
            "dockerPrivilegedMode": obj.get("dockerPrivilegedMode"),
            "passwordMinLength": obj.get("passwordMinLength"),
            "passwordMinUpperCase": obj.get("passwordMinUpperCase"),
            "passwordMinNumbers": obj.get("passwordMinNumbers"),
            "passwordMinSymbols": obj.get("passwordMinSymbols"),
            "userBrowserSessionTimeout": obj.get("userBrowserSessionTimeout"),
            "userBrowserSessionWarning": obj.get("userBrowserSessionWarning"),
            "expirePwdDays": obj.get("expirePwdDays"),
            "disableAfterAttempts": obj.get("disableAfterAttempts"),
            "disableAfterDaysInactive": obj.get("disableAfterDaysInactive"),
            "warnUserDaysBefore": obj.get("warnUserDaysBefore"),
            "smtpMailFrom": obj.get("smtpMailFrom"),
            "smtpServer": obj.get("smtpServer"),
            "smtpPort": obj.get("smtpPort"),
            "smtpSSL": obj.get("smtpSSL"),
            "smtpTLS": obj.get("smtpTLS"),
            "smtpUser": obj.get("smtpUser"),
            "smtpPassword": obj.get("smtpPassword"),
            "proxyHost": obj.get("proxyHost"),
            "proxyPort": obj.get("proxyPort"),
            "proxyUser": obj.get("proxyUser"),
            "proxyPassword": obj.get("proxyPassword"),
            "proxyDomain": obj.get("proxyDomain"),
            "proxyWorkstation": obj.get("proxyWorkstation"),
            "currencyProvider": obj.get("currencyProvider"),
            "currencyKey": obj.get("currencyKey"),
            "enableAllZoneTypes": obj.get("enableAllZoneTypes"),
            "enableZoneTypes": obj.get("enableZoneTypes"),
            "disableZoneTypes": obj.get("disableZoneTypes"),
            "disableAllZoneTypes": obj.get("disableAllZoneTypes"),
            "twilioAccountSid": obj.get("twilioAccountSid"),
            "twilioSmsFrom": obj.get("twilioSmsFrom"),
            "twilioAuthToken": obj.get("twilioAuthToken"),
            "cloudSyncIntervalSeconds": obj.get("cloudSyncIntervalSeconds"),
            "clusterSyncIntervalSeconds": obj.get("clusterSyncIntervalSeconds"),
            "usageRetainmentPeriod": obj.get("usageRetainmentPeriod"),
            "invoiceRetainmentPeriod": obj.get("invoiceRetainmentPeriod"),
            "incidentRetainmentPeriod": obj.get("incidentRetainmentPeriod"),
            "statsRetainmentPeriod": obj.get("statsRetainmentPeriod"),
            "reportsRetainmentPeriod": obj.get("reportsRetainmentPeriod"),
            "httpBlacklistHosts": obj.get("httpBlacklistHosts"),
            "httpApprovelistHosts": obj.get("httpApprovelistHosts"),
            "noAgent": obj.get("noAgent"),
            "agentSSLVerify": obj.get("agentSSLVerify"),
            "disableSSHPasswordAuth": obj.get("disableSSHPasswordAuth"),
            "defaultLocale": obj.get("defaultLocale"),
            "defaultVdiGateway": obj.get("defaultVdiGateway"),
            "maxOptionListSize": obj.get("maxOptionListSize"),
            "exchangeUrl": obj.get("exchangeUrl")
        })
        return _obj


