# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_archive_bucket200_response_archive_files_inner_archive_bucket import GetArchiveBucket200ResponseArchiveFilesInnerArchiveBucket
from morpheus.models.list_archive_buckets200_response_all_of_archive_buckets_inner_created_by import ListArchiveBuckets200ResponseAllOfArchiveBucketsInnerCreatedBy
from typing import Optional, Set
from typing_extensions import Self

class ArchiveBucketFile(BaseModel):
    """
    ArchiveBucketFile
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    file_path: Optional[StrictStr] = Field(default=None, alias="filePath")
    archive_bucket: Optional[GetArchiveBucket200ResponseArchiveFilesInnerArchiveBucket] = Field(default=None, alias="archiveBucket")
    created_by: Optional[ListArchiveBuckets200ResponseAllOfArchiveBucketsInnerCreatedBy] = Field(default=None, alias="createdBy")
    is_directory: Optional[StrictBool] = Field(default=None, alias="isDirectory")
    status: Optional[StrictStr] = None
    raw_size: Optional[StrictInt] = Field(default=None, alias="rawSize")
    content_type: Optional[StrictStr] = Field(default=None, alias="contentType")
    download_count: Optional[StrictInt] = Field(default=None, alias="downloadCount")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "name", "filePath", "archiveBucket", "createdBy", "isDirectory", "status", "rawSize", "contentType", "downloadCount", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ArchiveBucketFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of archive_bucket
        if self.archive_bucket:
            _dict['archiveBucket'] = self.archive_bucket.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # set to None if content_type (nullable) is None
        # and model_fields_set contains the field
        if self.content_type is None and "content_type" in self.model_fields_set:
            _dict['contentType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ArchiveBucketFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "filePath": obj.get("filePath"),
            "archiveBucket": GetArchiveBucket200ResponseArchiveFilesInnerArchiveBucket.from_dict(obj["archiveBucket"]) if obj.get("archiveBucket") is not None else None,
            "createdBy": ListArchiveBuckets200ResponseAllOfArchiveBucketsInnerCreatedBy.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "isDirectory": obj.get("isDirectory"),
            "status": obj.get("status"),
            "rawSize": obj.get("rawSize"),
            "contentType": obj.get("contentType"),
            "downloadCount": obj.get("downloadCount"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


