# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_cluster_request_cluster_cloud import AddClusterRequestClusterCloud
from morpheus.models.add_cluster_request_cluster_group import AddClusterRequestClusterGroup
from morpheus.models.add_cluster_request_cluster_layout import AddClusterRequestClusterLayout
from morpheus.models.add_cluster_request_cluster_server import AddClusterRequestClusterServer
from morpheus.models.add_cluster_request_cluster_type import AddClusterRequestClusterType
from typing import Optional, Set
from typing_extensions import Self

class ClusterCreate(BaseModel):
    """
    ClusterCreate
    """ # noqa: E501
    type: AddClusterRequestClusterType
    name: StrictStr = Field(description="Name of the cluster to be created")
    description: Optional[StrictStr] = Field(default=None, description="Description of the cluster to be created")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of strings (keywords). This will override labels passed under the `server` object.")
    group: AddClusterRequestClusterGroup
    cloud: AddClusterRequestClusterCloud
    layout: AddClusterRequestClusterLayout
    server: AddClusterRequestClusterServer
    auto_recover_power_state: Optional[StrictBool] = Field(default=False, description="Automatically Power on VMs", alias="autoRecoverPowerState")
    task_set_id: Optional[StrictInt] = Field(default=None, description="Optional Workflow Id desired to be run", alias="taskSetId")
    __properties: ClassVar[List[str]] = ["type", "name", "description", "labels", "group", "cloud", "layout", "server", "autoRecoverPowerState", "taskSetId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of layout
        if self.layout:
            _dict['layout'] = self.layout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of server
        if self.server:
            _dict['server'] = self.server.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": AddClusterRequestClusterType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "name": obj.get("name"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "group": AddClusterRequestClusterGroup.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "cloud": AddClusterRequestClusterCloud.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "layout": AddClusterRequestClusterLayout.from_dict(obj["layout"]) if obj.get("layout") is not None else None,
            "server": AddClusterRequestClusterServer.from_dict(obj["server"]) if obj.get("server") is not None else None,
            "autoRecoverPowerState": obj.get("autoRecoverPowerState") if obj.get("autoRecoverPowerState") is not None else False,
            "taskSetId": obj.get("taskSetId")
        })
        return _obj


