# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_catalog_item_types200_response_all_of_catalog_item_types_inner_option_types_inner import ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner
from morpheus.models.list_cluster_layouts200_response_all_of_layouts_inner_compute_servers_inner import ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInner
from morpheus.models.list_cluster_layouts200_response_all_of_layouts_inner_spec_templates_inner import ListClusterLayouts200ResponseAllOfLayoutsInnerSpecTemplatesInner
from typing import Optional, Set
from typing_extensions import Self

class ClusterLayout(BaseModel):
    """
    ClusterLayout
    """ # noqa: E501
    id: Optional[StrictInt] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    server_count: Optional[StrictInt] = Field(default=None, alias="serverCount")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    code: Optional[StrictStr] = None
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    has_auto_scale: Optional[StrictBool] = Field(default=None, alias="hasAutoScale")
    memory_requirement: Optional[StrictInt] = Field(default=None, alias="memoryRequirement")
    cluster_version: Optional[StrictStr] = Field(default=None, alias="clusterVersion")
    compute_version: Optional[StrictStr] = Field(default=None, alias="computeVersion")
    has_settings: Optional[StrictBool] = Field(default=None, alias="hasSettings")
    sort_order: Optional[StrictInt] = Field(default=None, alias="sortOrder")
    has_config: Optional[StrictBool] = Field(default=None, alias="hasConfig")
    name: Optional[StrictStr] = None
    creatable: Optional[StrictBool] = None
    enabled: Optional[StrictBool] = None
    description: Optional[StrictStr] = None
    group_type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="groupType")
    labels: Optional[List[StrictStr]] = None
    environment_variables: Optional[List[Dict[str, Any]]] = Field(default=None, alias="environmentVariables")
    option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    actions: Optional[List[Dict[str, Any]]] = None
    compute_servers: Optional[List[ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInner]] = Field(default=None, alias="computeServers")
    install_container_runtime: Optional[StrictBool] = Field(default=None, alias="installContainerRuntime")
    provision_type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="provisionType")
    spec_templates: Optional[List[ListClusterLayouts200ResponseAllOfLayoutsInnerSpecTemplatesInner]] = Field(default=None, alias="specTemplates")
    task_sets: Optional[List[Dict[str, Any]]] = Field(default=None, alias="taskSets")
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    __properties: ClassVar[List[str]] = ["id", "internalId", "serverCount", "dateCreated", "code", "lastUpdated", "hasAutoScale", "memoryRequirement", "clusterVersion", "computeVersion", "hasSettings", "sortOrder", "hasConfig", "name", "creatable", "enabled", "description", "groupType", "labels", "environmentVariables", "optionTypes", "actions", "computeServers", "installContainerRuntime", "provisionType", "specTemplates", "taskSets", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterLayout from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of group_type
        if self.group_type:
            _dict['groupType'] = self.group_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in compute_servers (list)
        _items = []
        if self.compute_servers:
            for _item_compute_servers in self.compute_servers:
                if _item_compute_servers:
                    _items.append(_item_compute_servers.to_dict())
            _dict['computeServers'] = _items
        # override the default output from pydantic by calling `to_dict()` of provision_type
        if self.provision_type:
            _dict['provisionType'] = self.provision_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in spec_templates (list)
        _items = []
        if self.spec_templates:
            for _item_spec_templates in self.spec_templates:
                if _item_spec_templates:
                    _items.append(_item_spec_templates.to_dict())
            _dict['specTemplates'] = _items
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterLayout from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "internalId": obj.get("internalId"),
            "serverCount": obj.get("serverCount"),
            "dateCreated": obj.get("dateCreated"),
            "code": obj.get("code"),
            "lastUpdated": obj.get("lastUpdated"),
            "hasAutoScale": obj.get("hasAutoScale"),
            "memoryRequirement": obj.get("memoryRequirement"),
            "clusterVersion": obj.get("clusterVersion"),
            "computeVersion": obj.get("computeVersion"),
            "hasSettings": obj.get("hasSettings"),
            "sortOrder": obj.get("sortOrder"),
            "hasConfig": obj.get("hasConfig"),
            "name": obj.get("name"),
            "creatable": obj.get("creatable"),
            "enabled": obj.get("enabled"),
            "description": obj.get("description"),
            "groupType": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["groupType"]) if obj.get("groupType") is not None else None,
            "labels": obj.get("labels"),
            "environmentVariables": obj.get("environmentVariables"),
            "optionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "actions": obj.get("actions"),
            "computeServers": [ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInner.from_dict(_item) for _item in obj["computeServers"]] if obj.get("computeServers") is not None else None,
            "installContainerRuntime": obj.get("installContainerRuntime"),
            "provisionType": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["provisionType"]) if obj.get("provisionType") is not None else None,
            "specTemplates": [ListClusterLayouts200ResponseAllOfLayoutsInnerSpecTemplatesInner.from_dict(_item) for _item in obj["specTemplates"]] if obj.get("specTemplates") is not None else None,
            "taskSets": obj.get("taskSets"),
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None
        })
        return _obj


