# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_catalog_item_types200_response_all_of_catalog_item_types_inner_option_types_inner import ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner
from morpheus.models.list_cluster_types200_response_all_of_cluster_types_inner_controller_types_inner import ListClusterTypes200ResponseAllOfClusterTypesInnerControllerTypesInner
from typing import Optional, Set
from typing_extensions import Self

class ClusterTypes(BaseModel):
    """
    ClusterTypes
    """ # noqa: E501
    id: Optional[StrictInt] = None
    deploy_target_service: Optional[StrictStr] = Field(default=None, alias="deployTargetService")
    short_name: Optional[StrictStr] = Field(default=None, alias="shortName")
    provider_type: Optional[StrictStr] = Field(default=None, alias="providerType")
    code: Optional[StrictStr] = None
    host_service: Optional[StrictStr] = Field(default=None, alias="hostService")
    managed: Optional[StrictBool] = None
    has_masters: Optional[StrictBool] = Field(default=None, alias="hasMasters")
    has_workers: Optional[StrictBool] = Field(default=None, alias="hasWorkers")
    view_set: Optional[StrictStr] = Field(default=None, alias="viewSet")
    image_code: Optional[StrictStr] = Field(default=None, alias="imageCode")
    kube_ctl_local: Optional[StrictBool] = Field(default=None, alias="kubeCtlLocal")
    has_datastore: Optional[StrictBool] = Field(default=None, alias="hasDatastore")
    supports_cloud_scaling: Optional[StrictBool] = Field(default=None, alias="supportsCloudScaling")
    name: Optional[StrictStr] = None
    has_default_data_disk: Optional[StrictBool] = Field(default=None, alias="hasDefaultDataDisk")
    can_manage: Optional[StrictBool] = Field(default=None, alias="canManage")
    has_cluster: Optional[StrictBool] = Field(default=None, alias="hasCluster")
    description: Optional[StrictStr] = None
    option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    controller_types: Optional[List[ListClusterTypes200ResponseAllOfClusterTypesInnerControllerTypesInner]] = Field(default=None, alias="controllerTypes")
    worker_types: Optional[List[ListClusterTypes200ResponseAllOfClusterTypesInnerControllerTypesInner]] = Field(default=None, alias="workerTypes")
    __properties: ClassVar[List[str]] = ["id", "deployTargetService", "shortName", "providerType", "code", "hostService", "managed", "hasMasters", "hasWorkers", "viewSet", "imageCode", "kubeCtlLocal", "hasDatastore", "supportsCloudScaling", "name", "hasDefaultDataDisk", "canManage", "hasCluster", "description", "optionTypes", "controllerTypes", "workerTypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClusterTypes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in controller_types (list)
        _items = []
        if self.controller_types:
            for _item_controller_types in self.controller_types:
                if _item_controller_types:
                    _items.append(_item_controller_types.to_dict())
            _dict['controllerTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in worker_types (list)
        _items = []
        if self.worker_types:
            for _item_worker_types in self.worker_types:
                if _item_worker_types:
                    _items.append(_item_worker_types.to_dict())
            _dict['workerTypes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClusterTypes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "deployTargetService": obj.get("deployTargetService"),
            "shortName": obj.get("shortName"),
            "providerType": obj.get("providerType"),
            "code": obj.get("code"),
            "hostService": obj.get("hostService"),
            "managed": obj.get("managed"),
            "hasMasters": obj.get("hasMasters"),
            "hasWorkers": obj.get("hasWorkers"),
            "viewSet": obj.get("viewSet"),
            "imageCode": obj.get("imageCode"),
            "kubeCtlLocal": obj.get("kubeCtlLocal"),
            "hasDatastore": obj.get("hasDatastore"),
            "supportsCloudScaling": obj.get("supportsCloudScaling"),
            "name": obj.get("name"),
            "hasDefaultDataDisk": obj.get("hasDefaultDataDisk"),
            "canManage": obj.get("canManage"),
            "hasCluster": obj.get("hasCluster"),
            "description": obj.get("description"),
            "optionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "controllerTypes": [ListClusterTypes200ResponseAllOfClusterTypesInnerControllerTypesInner.from_dict(_item) for _item in obj["controllerTypes"]] if obj.get("controllerTypes") is not None else None,
            "workerTypes": [ListClusterTypes200ResponseAllOfClusterTypesInnerControllerTypesInner.from_dict(_item) for _item in obj["workerTypes"]] if obj.get("workerTypes") is not None else None
        })
        return _obj


