# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.create_instance_schedule_request_instance_schedule_threshold import CreateInstanceScheduleRequestInstanceScheduleThreshold
from typing import Optional, Set
from typing_extensions import Self

class CreateInstanceScheduleRequestInstanceSchedule(BaseModel):
    """
    CreateInstanceScheduleRequestInstanceSchedule
    """ # noqa: E501
    schedule_type: Optional[StrictStr] = Field(default='dayOfWeek', alias="scheduleType")
    schedule_timezone: Optional[StrictStr] = Field(default='UTC', description="Time Zone eg. America/New_York, Europe/Amsterdam, etc. Only used and required for scheduleType `dayOfWeek`", alias="scheduleTimezone")
    start_day_of_week: Optional[StrictInt] = Field(default=None, description="Start day of the week 1-7 (Sun-Sat). Only used and required for scheduleType `dayOfWeek`", alias="startDayOfWeek")
    start_time: Optional[StrictStr] = Field(default=None, description="Start time of the day in 24-hour format. Only used and required for scheduleType `dayOfWeek`", alias="startTime")
    end_day_of_week: Optional[StrictInt] = Field(default=None, description="End day of the week 1-7 (Sun-Sat). Only used and required for scheduleType `dayOfWeek`", alias="endDayOfWeek")
    end_time: Optional[StrictStr] = Field(default=None, description="End time of the day in 24-hour format. Only used and required for scheduleType `dayOfWeek`", alias="endTime")
    start_date: Optional[datetime] = Field(default=None, description="Start Date. Only used and required for scheduleType `exact`", alias="startDate")
    end_date: Optional[datetime] = Field(default=None, description="End Date. Only used and required for scheduleType `exact`", alias="endDate")
    threshold: Optional[CreateInstanceScheduleRequestInstanceScheduleThreshold] = None
    __properties: ClassVar[List[str]] = ["scheduleType", "scheduleTimezone", "startDayOfWeek", "startTime", "endDayOfWeek", "endTime", "startDate", "endDate", "threshold"]

    @field_validator('schedule_type')
    def schedule_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['dayOfWeek', 'exact']):
            raise ValueError("must be one of enum values ('dayOfWeek', 'exact')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInstanceScheduleRequestInstanceSchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of threshold
        if self.threshold:
            _dict['threshold'] = self.threshold.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInstanceScheduleRequestInstanceSchedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "scheduleType": obj.get("scheduleType") if obj.get("scheduleType") is not None else 'dayOfWeek',
            "scheduleTimezone": obj.get("scheduleTimezone") if obj.get("scheduleTimezone") is not None else 'UTC',
            "startDayOfWeek": obj.get("startDayOfWeek"),
            "startTime": obj.get("startTime"),
            "endDayOfWeek": obj.get("endDayOfWeek"),
            "endTime": obj.get("endTime"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "threshold": CreateInstanceScheduleRequestInstanceScheduleThreshold.from_dict(obj["threshold"]) if obj.get("threshold") is not None else None
        })
        return _obj


