# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.create_network_pool200_response_network_pool_ip_ranges_inner import CreateNetworkPool200ResponseNetworkPoolIpRangesInner
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class CreateNetworkPool200ResponseNetworkPool(BaseModel):
    """
    CreateNetworkPool200ResponseNetworkPool
    """ # noqa: E501
    id: Optional[StrictInt] = None
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    category: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    dns_domain: Optional[StrictStr] = Field(default=None, alias="dnsDomain")
    dns_search_path: Optional[StrictStr] = Field(default=None, alias="dnsSearchPath")
    host_prefix: Optional[StrictStr] = Field(default=None, alias="hostPrefix")
    http_proxy: Optional[StrictStr] = Field(default=None, alias="httpProxy")
    dns_servers: Optional[List[StrictStr]] = Field(default=None, alias="dnsServers")
    dns_suffix_list: Optional[List[StrictStr]] = Field(default=None, alias="dnsSuffixList")
    dhcp_server: Optional[StrictBool] = Field(default=None, alias="dhcpServer")
    dhcp_ip: Optional[StrictStr] = Field(default=None, alias="dhcpIp")
    gateway: Optional[StrictStr] = None
    netmask: Optional[StrictStr] = None
    subnet_address: Optional[StrictStr] = Field(default=None, alias="subnetAddress")
    ip_count: Optional[StrictInt] = Field(default=None, alias="ipCount")
    free_count: Optional[StrictInt] = Field(default=None, alias="freeCount")
    pool_enabled: Optional[StrictBool] = Field(default=None, alias="poolEnabled")
    tftp_server: Optional[StrictStr] = Field(default=None, alias="tftpServer")
    boot_file: Optional[StrictStr] = Field(default=None, alias="bootFile")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictStr] = Field(default=None, alias="refId")
    parent_type: Optional[StrictStr] = Field(default=None, alias="parentType")
    parent_id: Optional[StrictStr] = Field(default=None, alias="parentId")
    pool_group: Optional[StrictStr] = Field(default=None, alias="poolGroup")
    ip_ranges: Optional[List[CreateNetworkPool200ResponseNetworkPoolIpRangesInner]] = Field(default=None, alias="ipRanges")
    __properties: ClassVar[List[str]] = ["id", "type", "account", "category", "code", "name", "displayName", "internalId", "externalId", "dnsDomain", "dnsSearchPath", "hostPrefix", "httpProxy", "dnsServers", "dnsSuffixList", "dhcpServer", "dhcpIp", "gateway", "netmask", "subnetAddress", "ipCount", "freeCount", "poolEnabled", "tftpServer", "bootFile", "refType", "refId", "parentType", "parentId", "poolGroup", "ipRanges"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateNetworkPool200ResponseNetworkPool from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in ip_ranges (list)
        _items = []
        if self.ip_ranges:
            for _item_ip_ranges in self.ip_ranges:
                if _item_ip_ranges:
                    _items.append(_item_ip_ranges.to_dict())
            _dict['ipRanges'] = _items
        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['displayName'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if dns_domain (nullable) is None
        # and model_fields_set contains the field
        if self.dns_domain is None and "dns_domain" in self.model_fields_set:
            _dict['dnsDomain'] = None

        # set to None if dns_search_path (nullable) is None
        # and model_fields_set contains the field
        if self.dns_search_path is None and "dns_search_path" in self.model_fields_set:
            _dict['dnsSearchPath'] = None

        # set to None if host_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.host_prefix is None and "host_prefix" in self.model_fields_set:
            _dict['hostPrefix'] = None

        # set to None if http_proxy (nullable) is None
        # and model_fields_set contains the field
        if self.http_proxy is None and "http_proxy" in self.model_fields_set:
            _dict['httpProxy'] = None

        # set to None if dhcp_ip (nullable) is None
        # and model_fields_set contains the field
        if self.dhcp_ip is None and "dhcp_ip" in self.model_fields_set:
            _dict['dhcpIp'] = None

        # set to None if gateway (nullable) is None
        # and model_fields_set contains the field
        if self.gateway is None and "gateway" in self.model_fields_set:
            _dict['gateway'] = None

        # set to None if netmask (nullable) is None
        # and model_fields_set contains the field
        if self.netmask is None and "netmask" in self.model_fields_set:
            _dict['netmask'] = None

        # set to None if subnet_address (nullable) is None
        # and model_fields_set contains the field
        if self.subnet_address is None and "subnet_address" in self.model_fields_set:
            _dict['subnetAddress'] = None

        # set to None if tftp_server (nullable) is None
        # and model_fields_set contains the field
        if self.tftp_server is None and "tftp_server" in self.model_fields_set:
            _dict['tftpServer'] = None

        # set to None if boot_file (nullable) is None
        # and model_fields_set contains the field
        if self.boot_file is None and "boot_file" in self.model_fields_set:
            _dict['bootFile'] = None

        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        # set to None if parent_type (nullable) is None
        # and model_fields_set contains the field
        if self.parent_type is None and "parent_type" in self.model_fields_set:
            _dict['parentType'] = None

        # set to None if parent_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_id is None and "parent_id" in self.model_fields_set:
            _dict['parentId'] = None

        # set to None if pool_group (nullable) is None
        # and model_fields_set contains the field
        if self.pool_group is None and "pool_group" in self.model_fields_set:
            _dict['poolGroup'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateNetworkPool200ResponseNetworkPool from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "category": obj.get("category"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "displayName": obj.get("displayName"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "dnsDomain": obj.get("dnsDomain"),
            "dnsSearchPath": obj.get("dnsSearchPath"),
            "hostPrefix": obj.get("hostPrefix"),
            "httpProxy": obj.get("httpProxy"),
            "dnsServers": obj.get("dnsServers"),
            "dnsSuffixList": obj.get("dnsSuffixList"),
            "dhcpServer": obj.get("dhcpServer"),
            "dhcpIp": obj.get("dhcpIp"),
            "gateway": obj.get("gateway"),
            "netmask": obj.get("netmask"),
            "subnetAddress": obj.get("subnetAddress"),
            "ipCount": obj.get("ipCount"),
            "freeCount": obj.get("freeCount"),
            "poolEnabled": obj.get("poolEnabled"),
            "tftpServer": obj.get("tftpServer"),
            "bootFile": obj.get("bootFile"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "parentType": obj.get("parentType"),
            "parentId": obj.get("parentId"),
            "poolGroup": obj.get("poolGroup"),
            "ipRanges": [CreateNetworkPool200ResponseNetworkPoolIpRangesInner.from_dict(_item) for _item in obj["ipRanges"]] if obj.get("ipRanges") is not None else None
        })
        return _obj


