# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateNetworkPool200ResponseNetworkPoolIpRangesInner(BaseModel):
    """
    CreateNetworkPool200ResponseNetworkPoolIpRangesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    start_address: Optional[StrictStr] = Field(default=None, alias="startAddress")
    end_address: Optional[StrictStr] = Field(default=None, alias="endAddress")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    description: Optional[StrictStr] = None
    address_count: Optional[StrictInt] = Field(default=None, alias="addressCount")
    active: Optional[StrictBool] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    cidr: Optional[StrictStr] = None
    cidr_ipv6: Optional[StrictStr] = Field(default=None, alias="cidrIPv6")
    __properties: ClassVar[List[str]] = ["id", "startAddress", "endAddress", "internalId", "externalId", "description", "addressCount", "active", "dateCreated", "lastUpdated", "cidr", "cidrIPv6"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateNetworkPool200ResponseNetworkPoolIpRangesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if start_address (nullable) is None
        # and model_fields_set contains the field
        if self.start_address is None and "start_address" in self.model_fields_set:
            _dict['startAddress'] = None

        # set to None if end_address (nullable) is None
        # and model_fields_set contains the field
        if self.end_address is None and "end_address" in self.model_fields_set:
            _dict['endAddress'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if cidr (nullable) is None
        # and model_fields_set contains the field
        if self.cidr is None and "cidr" in self.model_fields_set:
            _dict['cidr'] = None

        # set to None if cidr_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.cidr_ipv6 is None and "cidr_ipv6" in self.model_fields_set:
            _dict['cidrIPv6'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateNetworkPool200ResponseNetworkPoolIpRangesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "startAddress": obj.get("startAddress"),
            "endAddress": obj.get("endAddress"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "description": obj.get("description"),
            "addressCount": obj.get("addressCount"),
            "active": obj.get("active"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "cidr": obj.get("cidr"),
            "cidrIPv6": obj.get("cidrIPv6")
        })
        return _obj


