# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from typing import Optional, Set
from typing_extensions import Self

class CreateNetworkPoolIp200ResponseNetworkPool(BaseModel):
    """
    CreateNetworkPoolIp200ResponseNetworkPool
    """ # noqa: E501
    id: Optional[StrictInt] = None
    network_pool_id: Optional[StrictInt] = Field(default=None, alias="networkPoolId")
    ip_type: Optional[StrictStr] = Field(default=None, alias="ipType")
    ip_address: Optional[StrictStr] = Field(default=None, alias="ipAddress")
    gateway_address: Optional[StrictStr] = Field(default=None, alias="gatewayAddress")
    subnet_mask: Optional[StrictStr] = Field(default=None, alias="subnetMask")
    dns_server: Optional[StrictStr] = Field(default=None, alias="dnsServer")
    interface_name: Optional[StrictStr] = Field(default=None, alias="interfaceName")
    description: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    static_ip: Optional[StrictBool] = Field(default=None, alias="staticIp")
    fqdn: Optional[StrictStr] = None
    domain_name: Optional[StrictStr] = Field(default=None, alias="domainName")
    hostname: Optional[StrictStr] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    ptr_id: Optional[StrictStr] = Field(default=None, alias="ptrId")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    sub_ref_id: Optional[StrictInt] = Field(default=None, alias="subRefId")
    network_domain: Optional[StrictStr] = Field(default=None, alias="networkDomain")
    created_by: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = Field(default=None, alias="createdBy")
    __properties: ClassVar[List[str]] = ["id", "networkPoolId", "ipType", "ipAddress", "gatewayAddress", "subnetMask", "dnsServer", "interfaceName", "description", "active", "staticIp", "fqdn", "domainName", "hostname", "internalId", "externalId", "ptrId", "dateCreated", "lastUpdated", "startDate", "endDate", "refType", "refId", "subRefId", "networkDomain", "createdBy"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateNetworkPoolIp200ResponseNetworkPool from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # set to None if gateway_address (nullable) is None
        # and model_fields_set contains the field
        if self.gateway_address is None and "gateway_address" in self.model_fields_set:
            _dict['gatewayAddress'] = None

        # set to None if subnet_mask (nullable) is None
        # and model_fields_set contains the field
        if self.subnet_mask is None and "subnet_mask" in self.model_fields_set:
            _dict['subnetMask'] = None

        # set to None if dns_server (nullable) is None
        # and model_fields_set contains the field
        if self.dns_server is None and "dns_server" in self.model_fields_set:
            _dict['dnsServer'] = None

        # set to None if interface_name (nullable) is None
        # and model_fields_set contains the field
        if self.interface_name is None and "interface_name" in self.model_fields_set:
            _dict['interfaceName'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if domain_name (nullable) is None
        # and model_fields_set contains the field
        if self.domain_name is None and "domain_name" in self.model_fields_set:
            _dict['domainName'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if ptr_id (nullable) is None
        # and model_fields_set contains the field
        if self.ptr_id is None and "ptr_id" in self.model_fields_set:
            _dict['ptrId'] = None

        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        # set to None if sub_ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.sub_ref_id is None and "sub_ref_id" in self.model_fields_set:
            _dict['subRefId'] = None

        # set to None if network_domain (nullable) is None
        # and model_fields_set contains the field
        if self.network_domain is None and "network_domain" in self.model_fields_set:
            _dict['networkDomain'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateNetworkPoolIp200ResponseNetworkPool from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "networkPoolId": obj.get("networkPoolId"),
            "ipType": obj.get("ipType"),
            "ipAddress": obj.get("ipAddress"),
            "gatewayAddress": obj.get("gatewayAddress"),
            "subnetMask": obj.get("subnetMask"),
            "dnsServer": obj.get("dnsServer"),
            "interfaceName": obj.get("interfaceName"),
            "description": obj.get("description"),
            "active": obj.get("active"),
            "staticIp": obj.get("staticIp"),
            "fqdn": obj.get("fqdn"),
            "domainName": obj.get("domainName"),
            "hostname": obj.get("hostname"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "ptrId": obj.get("ptrId"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "subRefId": obj.get("subRefId"),
            "networkDomain": obj.get("networkDomain"),
            "createdBy": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None
        })
        return _obj


