# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ExecuteExecutionRequest200ResponseExecutionRequest(BaseModel):
    """
    ExecuteExecutionRequest200ResponseExecutionRequest
    """ # noqa: E501
    id: Optional[StrictInt] = None
    unique_id: Optional[StrictStr] = Field(default=None, alias="uniqueId")
    container_id: Optional[StrictStr] = Field(default=None, alias="containerId")
    server_id: Optional[StrictStr] = Field(default=None, alias="serverId")
    instance_id: Optional[StrictInt] = Field(default=None, alias="instanceId")
    resource_id: Optional[StrictStr] = Field(default=None, alias="resourceId")
    app_id: Optional[StrictStr] = Field(default=None, alias="appId")
    std_out: Optional[StrictStr] = Field(default=None, alias="stdOut")
    std_err: Optional[StrictStr] = Field(default=None, alias="stdErr")
    exit_code: Optional[StrictInt] = Field(default=None, alias="exitCode")
    status: Optional[StrictStr] = None
    expires_at: Optional[datetime] = Field(default=None, alias="expiresAt")
    created_by_id: Optional[StrictInt] = Field(default=None, alias="createdById")
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    config: Optional[Dict[str, Any]] = None
    raw_data: Optional[StrictStr] = Field(default=None, alias="rawData")
    __properties: ClassVar[List[str]] = ["id", "uniqueId", "containerId", "serverId", "instanceId", "resourceId", "appId", "stdOut", "stdErr", "exitCode", "status", "expiresAt", "createdById", "statusMessage", "errorMessage", "config", "rawData"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExecuteExecutionRequest200ResponseExecutionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if container_id (nullable) is None
        # and model_fields_set contains the field
        if self.container_id is None and "container_id" in self.model_fields_set:
            _dict['containerId'] = None

        # set to None if server_id (nullable) is None
        # and model_fields_set contains the field
        if self.server_id is None and "server_id" in self.model_fields_set:
            _dict['serverId'] = None

        # set to None if resource_id (nullable) is None
        # and model_fields_set contains the field
        if self.resource_id is None and "resource_id" in self.model_fields_set:
            _dict['resourceId'] = None

        # set to None if app_id (nullable) is None
        # and model_fields_set contains the field
        if self.app_id is None and "app_id" in self.model_fields_set:
            _dict['appId'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['errorMessage'] = None

        # set to None if raw_data (nullable) is None
        # and model_fields_set contains the field
        if self.raw_data is None and "raw_data" in self.model_fields_set:
            _dict['rawData'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExecuteExecutionRequest200ResponseExecutionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "uniqueId": obj.get("uniqueId"),
            "containerId": obj.get("containerId"),
            "serverId": obj.get("serverId"),
            "instanceId": obj.get("instanceId"),
            "resourceId": obj.get("resourceId"),
            "appId": obj.get("appId"),
            "stdOut": obj.get("stdOut"),
            "stdErr": obj.get("stdErr"),
            "exitCode": obj.get("exitCode"),
            "status": obj.get("status"),
            "expiresAt": obj.get("expiresAt"),
            "createdById": obj.get("createdById"),
            "statusMessage": obj.get("statusMessage"),
            "errorMessage": obj.get("errorMessage"),
            "config": obj.get("config"),
            "rawData": obj.get("rawData")
        })
        return _obj


