# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ExecuteTasksRequestJob(BaseModel):
    """
    ExecuteTasksRequestJob
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A name for the execution job. Can be used to find execution results with `/api/processes?name=`")
    target_type: Optional[StrictStr] = Field(default=None, description="The target context for task execution. This is required for tasks with `executeTarget` set to `resource`.", alias="targetType")
    instances: Optional[List[StrictInt]] = Field(default=None, description="Array of Instance IDs. Only applicable if `targetType` is instance.")
    servers: Optional[List[StrictInt]] = Field(default=None, description="Array of Server IDs. Only applicable if `targetType` is `server`.")
    instance_label: Optional[StrictStr] = Field(default=None, description="Instance Label. Only applicable if `targetType` is `instance-label`.", alias="instanceLabel")
    server_label: Optional[StrictStr] = Field(default=None, description="Server Label. Only applicable if `targetType` is `server-label`.", alias="serverLabel")
    custom_options: Optional[Dict[str, Any]] = Field(default=None, description="Map of options to be used as values in the task. These correspond to option types.", alias="customOptions")
    custom_config: Optional[StrictStr] = Field(default=None, description="String of custom configuration values as JSON.", alias="customConfig")
    __properties: ClassVar[List[str]] = ["name", "targetType", "instances", "servers", "instanceLabel", "serverLabel", "customOptions", "customConfig"]

    @field_validator('target_type')
    def target_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['appliance', 'instance', 'instance-label', 'server', 'server-label']):
            raise ValueError("must be one of enum values ('appliance', 'instance', 'instance-label', 'server', 'server-label')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExecuteTasksRequestJob from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExecuteTasksRequestJob from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "targetType": obj.get("targetType"),
            "instances": obj.get("instances"),
            "servers": obj.get("servers"),
            "instanceLabel": obj.get("instanceLabel"),
            "serverLabel": obj.get("serverLabel"),
            "customOptions": obj.get("customOptions"),
            "customConfig": obj.get("customConfig")
        })
        return _obj


