# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ExpirationPolicyTypeConfiguration(BaseModel):
    """
    Configuration settings for the following policy types: - Expiration 
    """ # noqa: E501
    lifecycle_type: Optional[StrictStr] = Field(default=None, alias="lifecycleType")
    lifecycle_age: Optional[StrictStr] = Field(default=None, alias="lifecycleAge")
    lifecycle_renewal: Optional[StrictStr] = Field(default=None, alias="lifecycleRenewal")
    lifecycle_notify: Optional[StrictStr] = Field(default=None, alias="lifecycleNotify")
    lifecycle_message: Optional[StrictStr] = Field(default=None, alias="lifecycleMessage")
    lifecycle_auto_renew: Optional[StrictStr] = Field(default='off', alias="lifecycleAutoRenew")
    lifecycle_allow_extend: Optional[StrictStr] = Field(default='off', alias="lifecycleAllowExtend")
    lifecycle_extensions_before_approval: Optional[StrictStr] = Field(default=None, alias="lifecycleExtensionsBeforeApproval")
    account_integration_id: Optional[StrictStr] = Field(default=None, alias="accountIntegrationId")
    lifecycle_hide_fixed: Optional[StrictBool] = Field(default=None, alias="lifecycleHideFixed")
    __properties: ClassVar[List[str]] = ["lifecycleType", "lifecycleAge", "lifecycleRenewal", "lifecycleNotify", "lifecycleMessage", "lifecycleAutoRenew", "lifecycleAllowExtend", "lifecycleExtensionsBeforeApproval", "accountIntegrationId", "lifecycleHideFixed"]

    @field_validator('lifecycle_auto_renew')
    def lifecycle_auto_renew_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['on', 'off']):
            raise ValueError("must be one of enum values ('on', 'off')")
        return value

    @field_validator('lifecycle_allow_extend')
    def lifecycle_allow_extend_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['on', 'off']):
            raise ValueError("must be one of enum values ('on', 'off')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExpirationPolicyTypeConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExpirationPolicyTypeConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "lifecycleType": obj.get("lifecycleType"),
            "lifecycleAge": obj.get("lifecycleAge"),
            "lifecycleRenewal": obj.get("lifecycleRenewal"),
            "lifecycleNotify": obj.get("lifecycleNotify"),
            "lifecycleMessage": obj.get("lifecycleMessage"),
            "lifecycleAutoRenew": obj.get("lifecycleAutoRenew") if obj.get("lifecycleAutoRenew") is not None else 'off',
            "lifecycleAllowExtend": obj.get("lifecycleAllowExtend") if obj.get("lifecycleAllowExtend") is not None else 'off',
            "lifecycleExtensionsBeforeApproval": obj.get("lifecycleExtensionsBeforeApproval"),
            "accountIntegrationId": obj.get("accountIntegrationId"),
            "lifecycleHideFixed": obj.get("lifecycleHideFixed")
        })
        return _obj


