# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FileTemplateUpdate(BaseModel):
    """
    FileTemplateUpdate
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="File template name")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    file_name: Optional[StrictStr] = Field(default=None, description="Filename for the file template", alias="fileName")
    file_path: Optional[StrictStr] = Field(default=None, description="Path for the file template", alias="filePath")
    category: Optional[StrictStr] = Field(default=None, description="Category")
    template_phase: Optional[StrictStr] = Field(default=None, description="Template Phase, provision, start, etc.", alias="templatePhase")
    template: Optional[StrictStr] = Field(default=None, description="Template content, that is, the file template content itself.")
    file_owner: Optional[StrictInt] = Field(default=None, description="File Owner", alias="fileOwner")
    setting_name: Optional[StrictStr] = Field(default=None, description="Setting Name", alias="settingName")
    setting_category: Optional[StrictStr] = Field(default=None, description="Setting Category", alias="settingCategory")
    __properties: ClassVar[List[str]] = ["name", "labels", "fileName", "filePath", "category", "templatePhase", "template", "fileOwner", "settingName", "settingCategory"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FileTemplateUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileTemplateUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "fileName": obj.get("fileName"),
            "filePath": obj.get("filePath"),
            "category": obj.get("category"),
            "templatePhase": obj.get("templatePhase"),
            "template": obj.get("template"),
            "fileOwner": obj.get("fileOwner"),
            "settingName": obj.get("settingName"),
            "settingCategory": obj.get("settingCategory")
        })
        return _obj


