# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, Dict, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_config_any_of import GetAlerts200ResponseAllOfChecksInnerConfigAnyOf
from morpheus.models.get_alerts200_response_all_of_checks_inner_config_any_of1 import GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1
from morpheus.models.get_alerts200_response_all_of_checks_inner_config_any_of2 import GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2
from morpheus.models.get_alerts200_response_all_of_checks_inner_config_any_of3 import GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3
from morpheus.models.get_alerts200_response_all_of_checks_inner_config_any_of4 import GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

GETALERTS200RESPONSEALLOFCHECKSINNERCONFIG_ANY_OF_SCHEMAS = ["GetAlerts200ResponseAllOfChecksInnerConfigAnyOf", "GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1", "GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2", "GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3", "GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4", "object"]

class GetAlerts200ResponseAllOfChecksInnerConfig(BaseModel):
    """
    GetAlerts200ResponseAllOfChecksInnerConfig
    """

    # data type: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf
    anyof_schema_1_validator: Optional[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf] = None
    # data type: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1
    anyof_schema_2_validator: Optional[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1] = None
    # data type: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2
    anyof_schema_3_validator: Optional[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2] = None
    # data type: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3
    anyof_schema_4_validator: Optional[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3] = None
    # data type: object
    anyof_schema_5_validator: Optional[Dict[str, Any]] = None
    # data type: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4
    anyof_schema_6_validator: Optional[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4, object]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "GetAlerts200ResponseAllOfChecksInnerConfigAnyOf", "GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1", "GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2", "GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3", "GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4", "object" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = GetAlerts200ResponseAllOfChecksInnerConfig.model_construct()
        error_messages = []
        # validate data type: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf
        if not isinstance(v, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GetAlerts200ResponseAllOfChecksInnerConfigAnyOf`")
        else:
            return v

        # validate data type: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1
        if not isinstance(v, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1`")
        else:
            return v

        # validate data type: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2
        if not isinstance(v, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2`")
        else:
            return v

        # validate data type: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3
        if not isinstance(v, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3`")
        else:
            return v

        # validate data type: object
        try:
            instance.anyof_schema_5_validator = v
            return v
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # validate data type: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4
        if not isinstance(v, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in GetAlerts200ResponseAllOfChecksInnerConfig with anyOf schemas: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4, object. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf] = None
        try:
            instance.actual_instance = GetAlerts200ResponseAllOfChecksInnerConfigAnyOf.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1] = None
        try:
            instance.actual_instance = GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2] = None
        try:
            instance.actual_instance = GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3] = None
        try:
            instance.actual_instance = GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # deserialize data into object
        try:
            # validation
            instance.anyof_schema_5_validator = json.loads(json_str)
            # assign value to actual_instance
            instance.actual_instance = instance.anyof_schema_5_validator
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # anyof_schema_6_validator: Optional[GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4] = None
        try:
            instance.actual_instance = GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into GetAlerts200ResponseAllOfChecksInnerConfig with anyOf schemas: GetAlerts200ResponseAllOfChecksInnerConfigAnyOf, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4, object. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], GetAlerts200ResponseAllOfChecksInnerConfigAnyOf, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf1, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf2, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf3, GetAlerts200ResponseAllOfChecksInnerConfigAnyOf4, object]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


