# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.get_approvals_item200_response_approval_item import GetApprovalsItem200ResponseApprovalItem
from typing import Optional, Set
from typing_extensions import Self

class GetApprovals200ResponseApproval(BaseModel):
    """
    GetApprovals200ResponseApproval
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    external_name: Optional[StrictStr] = Field(default=None, alias="externalName")
    request_type: Optional[StrictStr] = Field(default=None, alias="requestType")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    approver: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    account_integration: Optional[StrictStr] = Field(default=None, alias="accountIntegration")
    status: Optional[StrictStr] = None
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    request_by: Optional[StrictStr] = Field(default=None, alias="requestBy")
    approval_items: Optional[List[GetApprovalsItem200ResponseApprovalItem]] = Field(default=None, alias="approvalItems")
    __properties: ClassVar[List[str]] = ["id", "name", "internalId", "externalId", "externalName", "requestType", "account", "approver", "accountIntegration", "status", "errorMessage", "dateCreated", "lastUpdated", "requestBy", "approvalItems"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetApprovals200ResponseApproval from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of approver
        if self.approver:
            _dict['approver'] = self.approver.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in approval_items (list)
        _items = []
        if self.approval_items:
            for _item_approval_items in self.approval_items:
                if _item_approval_items:
                    _items.append(_item_approval_items.to_dict())
            _dict['approvalItems'] = _items
        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if external_name (nullable) is None
        # and model_fields_set contains the field
        if self.external_name is None and "external_name" in self.model_fields_set:
            _dict['externalName'] = None

        # set to None if account_integration (nullable) is None
        # and model_fields_set contains the field
        if self.account_integration is None and "account_integration" in self.model_fields_set:
            _dict['accountIntegration'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['errorMessage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetApprovals200ResponseApproval from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "externalName": obj.get("externalName"),
            "requestType": obj.get("requestType"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "approver": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["approver"]) if obj.get("approver") is not None else None,
            "accountIntegration": obj.get("accountIntegration"),
            "status": obj.get("status"),
            "errorMessage": obj.get("errorMessage"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "requestBy": obj.get("requestBy"),
            "approvalItems": [GetApprovalsItem200ResponseApprovalItem.from_dict(_item) for _item in obj["approvalItems"]] if obj.get("approvalItems") is not None else None
        })
        return _obj


