# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_container_types_inner_account import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_container_types_inner_container_ports_inner import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerContainerPortsInner
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner_container_types_inner_provision_type import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerProvisionType
from typing import Optional, Set
from typing_extensions import Self

class GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInner(BaseModel):
    """
    GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account: Optional[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    short_name: Optional[StrictStr] = Field(default=None, alias="shortName")
    code: Optional[StrictStr] = None
    container_version: Optional[StrictStr] = Field(default=None, alias="containerVersion")
    provision_type: Optional[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerProvisionType] = Field(default=None, alias="provisionType")
    virtual_image: Optional[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount] = Field(default=None, alias="virtualImage")
    os_type: Optional[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount] = Field(default=None, alias="osType")
    category: Optional[StrictStr] = None
    config: Optional[Dict[str, Any]] = None
    container_ports: Optional[List[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerContainerPortsInner]] = Field(default=None, alias="containerPorts")
    container_scripts: Optional[List[Dict[str, Any]]] = Field(default=None, alias="containerScripts")
    container_templates: Optional[List[Dict[str, Any]]] = Field(default=None, alias="containerTemplates")
    environment_variables: Optional[List[Dict[str, Any]]] = Field(default=None, alias="environmentVariables")
    __properties: ClassVar[List[str]] = ["id", "account", "name", "labels", "shortName", "code", "containerVersion", "provisionType", "virtualImage", "osType", "category", "config", "containerPorts", "containerScripts", "containerTemplates", "environmentVariables"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of provision_type
        if self.provision_type:
            _dict['provisionType'] = self.provision_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of virtual_image
        if self.virtual_image:
            _dict['virtualImage'] = self.virtual_image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of os_type
        if self.os_type:
            _dict['osType'] = self.os_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in container_ports (list)
        _items = []
        if self.container_ports:
            for _item_container_ports in self.container_ports:
                if _item_container_ports:
                    _items.append(_item_container_ports.to_dict())
            _dict['containerPorts'] = _items
        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if config (nullable) is None
        # and model_fields_set contains the field
        if self.config is None and "config" in self.model_fields_set:
            _dict['config'] = None

        # set to None if container_ports (nullable) is None
        # and model_fields_set contains the field
        if self.container_ports is None and "container_ports" in self.model_fields_set:
            _dict['containerPorts'] = None

        # set to None if container_scripts (nullable) is None
        # and model_fields_set contains the field
        if self.container_scripts is None and "container_scripts" in self.model_fields_set:
            _dict['containerScripts'] = None

        # set to None if container_templates (nullable) is None
        # and model_fields_set contains the field
        if self.container_templates is None and "container_templates" in self.model_fields_set:
            _dict['containerTemplates'] = None

        # set to None if environment_variables (nullable) is None
        # and model_fields_set contains the field
        if self.environment_variables is None and "environment_variables" in self.model_fields_set:
            _dict['environmentVariables'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account": GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "shortName": obj.get("shortName"),
            "code": obj.get("code"),
            "containerVersion": obj.get("containerVersion"),
            "provisionType": GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerProvisionType.from_dict(obj["provisionType"]) if obj.get("provisionType") is not None else None,
            "virtualImage": GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount.from_dict(obj["virtualImage"]) if obj.get("virtualImage") is not None else None,
            "osType": GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerAccount.from_dict(obj["osType"]) if obj.get("osType") is not None else None,
            "category": obj.get("category"),
            "config": obj.get("config"),
            "containerPorts": [GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInnerContainerTypesInnerContainerPortsInner.from_dict(_item) for _item in obj["containerPorts"]] if obj.get("containerPorts") is not None else None,
            "containerScripts": obj.get("containerScripts"),
            "containerTemplates": obj.get("containerTemplates"),
            "environmentVariables": obj.get("environmentVariables")
        })
        return _obj


