# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_license200_response_license_features import GetLicense200ResponseLicenseFeatures
from typing import Optional, Set
from typing_extensions import Self

class GetLicense200ResponseInstalledLicensesInner(BaseModel):
    """
    GetLicense200ResponseInstalledLicensesInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="ID")
    key_id: Optional[StrictStr] = Field(default=None, description="Key ID (only the first 8 characters are required to identify license to uninstall)", alias="keyId")
    hash: Optional[StrictStr] = Field(default=None, description="Hash of the license content which can be used as a fingerprint identifier")
    license_version: Optional[StrictInt] = Field(default=None, description="License Version which determines the required appliance version to install this license.", alias="licenseVersion")
    product_tier: Optional[StrictStr] = Field(default=None, description="Product Tier", alias="productTier")
    start_date: Optional[datetime] = Field(default=None, description="The start date of the applied license.", alias="startDate")
    end_date: Optional[datetime] = Field(default=None, description="The expiration date of the applied license.", alias="endDate")
    max_instances: Optional[StrictInt] = Field(default=None, description="Workload Limit. 0 is used for unlimited.", alias="maxInstances")
    max_memory: Optional[StrictInt] = Field(default=None, description="Memory Limit. 0 is used for unlimited.", alias="maxMemory")
    max_storage: Optional[StrictInt] = Field(default=None, description="Storage Limit. 0 is used for unlimited.", alias="maxStorage")
    limit_type: Optional[StrictStr] = Field(default=None, description="The limit type determines which limits apply to the license, the new 'standard' or legacy 'workload'.", alias="limitType")
    max_managed_servers: Optional[StrictInt] = Field(default=None, description="Managed Servers Limit. 0 is enforced and null is used for unlimited.", alias="maxManagedServers")
    max_discovered_servers: Optional[StrictInt] = Field(default=None, description="Discovered Servers Limit. 0 is enforced and null is used for unlimited.", alias="maxDiscoveredServers")
    max_hosts: Optional[StrictInt] = Field(default=None, description="Host Limit. 0 is enforced and null is used for unlimited.", alias="maxHosts")
    max_mvm: Optional[StrictInt] = Field(default=None, description="HPE VM Host Limit. 0 is enforced and null is used for unlimited.", alias="maxMvm")
    max_mvm_sockets: Optional[StrictInt] = Field(default=None, description="HPE VM Host Limit. 0 is enforced and null is used for unlimited.", alias="maxMvmSockets")
    max_sockets: Optional[StrictInt] = Field(default=None, description="Global Socket Limit. 0 is enforced and null is used for unlimited.", alias="maxSockets")
    max_iac: Optional[StrictInt] = Field(default=None, description="IAC Deployments Limit. 0 is enforced and null is used for unlimited.", alias="maxIac")
    max_xaas: Optional[StrictInt] = Field(default=None, description="Xaas Instances Limit. 0 is enforced and null is used for unlimited.", alias="maxXaas")
    max_executions: Optional[StrictInt] = Field(default=None, description="Execution Limit. 0 is enforced and null is used for unlimited.", alias="maxExecutions")
    max_distributed_workers: Optional[StrictInt] = Field(default=None, description="Distributed Workers Limit. 0 is enforced and null is used for unlimited.", alias="maxDistributedWorkers")
    max_discovered_objects: Optional[StrictInt] = Field(default=None, description="Discovered Objects Limit. Not yet enforced.", alias="maxDiscoveredObjects")
    hard_limit: Optional[StrictBool] = Field(default=None, description="Hard Limit", alias="hardLimit")
    free_trial: Optional[StrictBool] = Field(default=None, description="Free Trial (Community License)", alias="freeTrial")
    multi_tenant: Optional[StrictBool] = Field(default=None, description="Multi-Tenant Enabled", alias="multiTenant")
    whitelabel: Optional[StrictBool] = Field(default=None, description="White Label Enabled")
    report_status: Optional[StrictBool] = Field(default=None, description="Stats Reporting. This is true when the appliance registers and sends usage stats to the hub.", alias="reportStatus")
    support_level: Optional[StrictStr] = Field(default=None, description="Support Level", alias="supportLevel")
    account_name: Optional[StrictStr] = Field(default=None, description="Account Name", alias="accountName")
    config: Optional[Dict[str, Any]] = Field(default=None, description="License Configuration Object")
    amazon_product_codes: Optional[StrictStr] = Field(default=None, alias="amazonProductCodes")
    features: Optional[GetLicense200ResponseLicenseFeatures] = None
    zone_types: Optional[StrictStr] = Field(default=None, alias="zoneTypes")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    recalculation_date: Optional[datetime] = Field(default=None, alias="recalculationDate")
    __properties: ClassVar[List[str]] = ["id", "keyId", "hash", "licenseVersion", "productTier", "startDate", "endDate", "maxInstances", "maxMemory", "maxStorage", "limitType", "maxManagedServers", "maxDiscoveredServers", "maxHosts", "maxMvm", "maxMvmSockets", "maxSockets", "maxIac", "maxXaas", "maxExecutions", "maxDistributedWorkers", "maxDiscoveredObjects", "hardLimit", "freeTrial", "multiTenant", "whitelabel", "reportStatus", "supportLevel", "accountName", "config", "amazonProductCodes", "features", "zoneTypes", "lastUpdated", "dateCreated", "recalculationDate"]

    @field_validator('limit_type')
    def limit_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['standard', 'workload']):
            raise ValueError("must be one of enum values ('standard', 'workload')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetLicense200ResponseInstalledLicensesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of features
        if self.features:
            _dict['features'] = self.features.to_dict()
        # set to None if max_managed_servers (nullable) is None
        # and model_fields_set contains the field
        if self.max_managed_servers is None and "max_managed_servers" in self.model_fields_set:
            _dict['maxManagedServers'] = None

        # set to None if max_discovered_servers (nullable) is None
        # and model_fields_set contains the field
        if self.max_discovered_servers is None and "max_discovered_servers" in self.model_fields_set:
            _dict['maxDiscoveredServers'] = None

        # set to None if max_hosts (nullable) is None
        # and model_fields_set contains the field
        if self.max_hosts is None and "max_hosts" in self.model_fields_set:
            _dict['maxHosts'] = None

        # set to None if max_mvm (nullable) is None
        # and model_fields_set contains the field
        if self.max_mvm is None and "max_mvm" in self.model_fields_set:
            _dict['maxMvm'] = None

        # set to None if max_mvm_sockets (nullable) is None
        # and model_fields_set contains the field
        if self.max_mvm_sockets is None and "max_mvm_sockets" in self.model_fields_set:
            _dict['maxMvmSockets'] = None

        # set to None if max_sockets (nullable) is None
        # and model_fields_set contains the field
        if self.max_sockets is None and "max_sockets" in self.model_fields_set:
            _dict['maxSockets'] = None

        # set to None if max_iac (nullable) is None
        # and model_fields_set contains the field
        if self.max_iac is None and "max_iac" in self.model_fields_set:
            _dict['maxIac'] = None

        # set to None if max_xaas (nullable) is None
        # and model_fields_set contains the field
        if self.max_xaas is None and "max_xaas" in self.model_fields_set:
            _dict['maxXaas'] = None

        # set to None if max_executions (nullable) is None
        # and model_fields_set contains the field
        if self.max_executions is None and "max_executions" in self.model_fields_set:
            _dict['maxExecutions'] = None

        # set to None if max_distributed_workers (nullable) is None
        # and model_fields_set contains the field
        if self.max_distributed_workers is None and "max_distributed_workers" in self.model_fields_set:
            _dict['maxDistributedWorkers'] = None

        # set to None if max_discovered_objects (nullable) is None
        # and model_fields_set contains the field
        if self.max_discovered_objects is None and "max_discovered_objects" in self.model_fields_set:
            _dict['maxDiscoveredObjects'] = None

        # set to None if config (nullable) is None
        # and model_fields_set contains the field
        if self.config is None and "config" in self.model_fields_set:
            _dict['config'] = None

        # set to None if amazon_product_codes (nullable) is None
        # and model_fields_set contains the field
        if self.amazon_product_codes is None and "amazon_product_codes" in self.model_fields_set:
            _dict['amazonProductCodes'] = None

        # set to None if zone_types (nullable) is None
        # and model_fields_set contains the field
        if self.zone_types is None and "zone_types" in self.model_fields_set:
            _dict['zoneTypes'] = None

        # set to None if recalculation_date (nullable) is None
        # and model_fields_set contains the field
        if self.recalculation_date is None and "recalculation_date" in self.model_fields_set:
            _dict['recalculationDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetLicense200ResponseInstalledLicensesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "keyId": obj.get("keyId"),
            "hash": obj.get("hash"),
            "licenseVersion": obj.get("licenseVersion"),
            "productTier": obj.get("productTier"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "maxInstances": obj.get("maxInstances"),
            "maxMemory": obj.get("maxMemory"),
            "maxStorage": obj.get("maxStorage"),
            "limitType": obj.get("limitType"),
            "maxManagedServers": obj.get("maxManagedServers"),
            "maxDiscoveredServers": obj.get("maxDiscoveredServers"),
            "maxHosts": obj.get("maxHosts"),
            "maxMvm": obj.get("maxMvm"),
            "maxMvmSockets": obj.get("maxMvmSockets"),
            "maxSockets": obj.get("maxSockets"),
            "maxIac": obj.get("maxIac"),
            "maxXaas": obj.get("maxXaas"),
            "maxExecutions": obj.get("maxExecutions"),
            "maxDistributedWorkers": obj.get("maxDistributedWorkers"),
            "maxDiscoveredObjects": obj.get("maxDiscoveredObjects"),
            "hardLimit": obj.get("hardLimit"),
            "freeTrial": obj.get("freeTrial"),
            "multiTenant": obj.get("multiTenant"),
            "whitelabel": obj.get("whitelabel"),
            "reportStatus": obj.get("reportStatus"),
            "supportLevel": obj.get("supportLevel"),
            "accountName": obj.get("accountName"),
            "config": obj.get("config"),
            "amazonProductCodes": obj.get("amazonProductCodes"),
            "features": GetLicense200ResponseLicenseFeatures.from_dict(obj["features"]) if obj.get("features") is not None else None,
            "zoneTypes": obj.get("zoneTypes"),
            "lastUpdated": obj.get("lastUpdated"),
            "dateCreated": obj.get("dateCreated"),
            "recalculationDate": obj.get("recalculationDate")
        })
        return _obj


