# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_monitoring_settings200_response_monitoring_settings_service_now_integration import GetMonitoringSettings200ResponseMonitoringSettingsServiceNowIntegration
from typing import Optional, Set
from typing_extensions import Self

class GetMonitoringSettings200ResponseMonitoringSettingsServiceNow(BaseModel):
    """
    Service Now Settings
    """ # noqa: E501
    enabled: Optional[StrictBool] = Field(default=None, description="Enabled")
    integration: Optional[GetMonitoringSettings200ResponseMonitoringSettingsServiceNowIntegration] = None
    new_incident_action: Optional[StrictStr] = Field(default=None, description="New Incident Action", alias="newIncidentAction")
    close_incident_action: Optional[StrictStr] = Field(default=None, description="Close Incident Action", alias="closeIncidentAction")
    info_mapping: Optional[StrictStr] = Field(default=None, description="Info Mapping", alias="infoMapping")
    warning_mapping: Optional[StrictStr] = Field(default=None, description="Warning Mapping", alias="warningMapping")
    critical_mapping: Optional[StrictStr] = Field(default=None, description="Critical Mapping", alias="criticalMapping")
    __properties: ClassVar[List[str]] = ["enabled", "integration", "newIncidentAction", "closeIncidentAction", "infoMapping", "warningMapping", "criticalMapping"]

    @field_validator('new_incident_action')
    def new_incident_action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['create', 'none']):
            raise ValueError("must be one of enum values ('create', 'none')")
        return value

    @field_validator('close_incident_action')
    def close_incident_action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['close', 'activity', 'none']):
            raise ValueError("must be one of enum values ('close', 'activity', 'none')")
        return value

    @field_validator('info_mapping')
    def info_mapping_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['low', 'medium', 'high']):
            raise ValueError("must be one of enum values ('low', 'medium', 'high')")
        return value

    @field_validator('warning_mapping')
    def warning_mapping_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['low', 'medium', 'high']):
            raise ValueError("must be one of enum values ('low', 'medium', 'high')")
        return value

    @field_validator('critical_mapping')
    def critical_mapping_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['low', 'medium', 'high']):
            raise ValueError("must be one of enum values ('low', 'medium', 'high')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetMonitoringSettings200ResponseMonitoringSettingsServiceNow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of integration
        if self.integration:
            _dict['integration'] = self.integration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetMonitoringSettings200ResponseMonitoringSettingsServiceNow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enabled": obj.get("enabled"),
            "integration": GetMonitoringSettings200ResponseMonitoringSettingsServiceNowIntegration.from_dict(obj["integration"]) if obj.get("integration") is not None else None,
            "newIncidentAction": obj.get("newIncidentAction"),
            "closeIncidentAction": obj.get("closeIncidentAction"),
            "infoMapping": obj.get("infoMapping"),
            "warningMapping": obj.get("warningMapping"),
            "criticalMapping": obj.get("criticalMapping")
        })
        return _obj


