# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_network_router200_response_network_router_firewall import GetNetworkRouter200ResponseNetworkRouterFirewall
from morpheus.models.get_network_router200_response_network_router_network_server import GetNetworkRouter200ResponseNetworkRouterNetworkServer
from morpheus.models.get_network_router200_response_network_router_permissions import GetNetworkRouter200ResponseNetworkRouterPermissions
from morpheus.models.get_network_router200_response_network_router_type import GetNetworkRouter200ResponseNetworkRouterType
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class GetNetworkRouter200ResponseNetworkRouter(BaseModel):
    """
    GetNetworkRouter200ResponseNetworkRouter
    """ # noqa: E501
    id: Optional[StrictInt] = None
    code: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    router_type: Optional[StrictStr] = Field(default=None, alias="routerType")
    status: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    external_ip: Optional[StrictStr] = Field(default=None, alias="externalIp")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    provider_id: Optional[StrictStr] = Field(default=None, alias="providerId")
    type: Optional[GetNetworkRouter200ResponseNetworkRouterType] = None
    network_server: Optional[GetNetworkRouter200ResponseNetworkRouterNetworkServer] = Field(default=None, alias="networkServer")
    zone: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    instance: Optional[StrictStr] = None
    external_network: Optional[StrictStr] = Field(default=None, alias="externalNetwork")
    site: Optional[StrictStr] = None
    interfaces: Optional[List[Dict[str, Any]]] = None
    firewall: Optional[GetNetworkRouter200ResponseNetworkRouterFirewall] = None
    routes: Optional[List[Dict[str, Any]]] = None
    nats: Optional[List[Dict[str, Any]]] = None
    permissions: Optional[GetNetworkRouter200ResponseNetworkRouterPermissions] = None
    __properties: ClassVar[List[str]] = ["id", "code", "name", "description", "category", "dateCreated", "lastUpdated", "routerType", "status", "enabled", "externalIp", "externalId", "providerId", "type", "networkServer", "zone", "instance", "externalNetwork", "site", "interfaces", "firewall", "routes", "nats", "permissions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetNetworkRouter200ResponseNetworkRouter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of firewall
        if self.firewall:
            _dict['firewall'] = self.firewall.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if external_ip (nullable) is None
        # and model_fields_set contains the field
        if self.external_ip is None and "external_ip" in self.model_fields_set:
            _dict['externalIp'] = None

        # set to None if instance (nullable) is None
        # and model_fields_set contains the field
        if self.instance is None and "instance" in self.model_fields_set:
            _dict['instance'] = None

        # set to None if external_network (nullable) is None
        # and model_fields_set contains the field
        if self.external_network is None and "external_network" in self.model_fields_set:
            _dict['externalNetwork'] = None

        # set to None if site (nullable) is None
        # and model_fields_set contains the field
        if self.site is None and "site" in self.model_fields_set:
            _dict['site'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetNetworkRouter200ResponseNetworkRouter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "category": obj.get("category"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "routerType": obj.get("routerType"),
            "status": obj.get("status"),
            "enabled": obj.get("enabled"),
            "externalIp": obj.get("externalIp"),
            "externalId": obj.get("externalId"),
            "providerId": obj.get("providerId"),
            "type": GetNetworkRouter200ResponseNetworkRouterType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "networkServer": GetNetworkRouter200ResponseNetworkRouterNetworkServer.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None,
            "zone": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "instance": obj.get("instance"),
            "externalNetwork": obj.get("externalNetwork"),
            "site": obj.get("site"),
            "interfaces": obj.get("interfaces"),
            "firewall": GetNetworkRouter200ResponseNetworkRouterFirewall.from_dict(obj["firewall"]) if obj.get("firewall") is not None else None,
            "routes": obj.get("routes"),
            "nats": obj.get("nats"),
            "permissions": GetNetworkRouter200ResponseNetworkRouterPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None
        })
        return _obj


