# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_report_types200_response_report_types_inner_option_types_inner import GetReportTypes200ResponseReportTypesInnerOptionTypesInner
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class GetReportTypes200ResponseReportTypesInner(BaseModel):
    """
    GetReportTypes200ResponseReportTypesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    code: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    visible: Optional[StrictBool] = None
    master_only: Optional[StrictBool] = Field(default=None, alias="masterOnly")
    owner_only: Optional[StrictBool] = Field(default=None, alias="ownerOnly")
    supports_all_zone_types: Optional[StrictBool] = Field(default=None, alias="supportsAllZoneTypes")
    is_plugin: Optional[StrictBool] = Field(default=None, alias="isPlugin")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    option_types: Optional[List[GetReportTypes200ResponseReportTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    supported_zone_types: Optional[List[ListBackupSettings200ResponseBackupSettingsDefaultSchedule]] = Field(default=None, alias="supportedZoneTypes")
    __properties: ClassVar[List[str]] = ["id", "code", "name", "description", "category", "visible", "masterOnly", "ownerOnly", "supportsAllZoneTypes", "isPlugin", "dateCreated", "optionTypes", "supportedZoneTypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetReportTypes200ResponseReportTypesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in supported_zone_types (list)
        _items = []
        if self.supported_zone_types:
            for _item_supported_zone_types in self.supported_zone_types:
                if _item_supported_zone_types:
                    _items.append(_item_supported_zone_types.to_dict())
            _dict['supportedZoneTypes'] = _items
        # set to None if is_plugin (nullable) is None
        # and model_fields_set contains the field
        if self.is_plugin is None and "is_plugin" in self.model_fields_set:
            _dict['isPlugin'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetReportTypes200ResponseReportTypesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "category": obj.get("category"),
            "visible": obj.get("visible"),
            "masterOnly": obj.get("masterOnly"),
            "ownerOnly": obj.get("ownerOnly"),
            "supportsAllZoneTypes": obj.get("supportsAllZoneTypes"),
            "isPlugin": obj.get("isPlugin"),
            "dateCreated": obj.get("dateCreated"),
            "optionTypes": [GetReportTypes200ResponseReportTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "supportedZoneTypes": [ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(_item) for _item in obj["supportedZoneTypes"]] if obj.get("supportedZoneTypes") is not None else None
        })
        return _obj


