# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_health200_response_all_of_health_cpu import ListHealth200ResponseAllOfHealthCpu
from morpheus.models.list_health200_response_all_of_health_database import ListHealth200ResponseAllOfHealthDatabase
from morpheus.models.list_health200_response_all_of_health_elastic import ListHealth200ResponseAllOfHealthElastic
from morpheus.models.list_health200_response_all_of_health_memory import ListHealth200ResponseAllOfHealthMemory
from morpheus.models.list_health200_response_all_of_health_rabbit import ListHealth200ResponseAllOfHealthRabbit
from morpheus.models.list_health200_response_all_of_health_threads import ListHealth200ResponseAllOfHealthThreads
from typing import Optional, Set
from typing_extensions import Self

class Health(BaseModel):
    """
    Health
    """ # noqa: E501
    success: Optional[StrictBool] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    appliance_url: Optional[StrictStr] = Field(default=None, alias="applianceUrl")
    build_version: Optional[StrictStr] = Field(default=None, alias="buildVersion")
    uuid: Optional[StrictStr] = None
    setup_needed: Optional[StrictBool] = Field(default=None, alias="setupNeeded")
    var_date: Optional[datetime] = Field(default=None, alias="date")
    cpu: Optional[ListHealth200ResponseAllOfHealthCpu] = None
    memory: Optional[ListHealth200ResponseAllOfHealthMemory] = None
    threads: Optional[ListHealth200ResponseAllOfHealthThreads] = None
    database: Optional[ListHealth200ResponseAllOfHealthDatabase] = None
    elastic: Optional[ListHealth200ResponseAllOfHealthElastic] = None
    rabbit: Optional[ListHealth200ResponseAllOfHealthRabbit] = None
    __properties: ClassVar[List[str]] = ["success", "statusMessage", "applianceUrl", "buildVersion", "uuid", "setupNeeded", "date", "cpu", "memory", "threads", "database", "elastic", "rabbit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Health from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cpu
        if self.cpu:
            _dict['cpu'] = self.cpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of memory
        if self.memory:
            _dict['memory'] = self.memory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of threads
        if self.threads:
            _dict['threads'] = self.threads.to_dict()
        # override the default output from pydantic by calling `to_dict()` of database
        if self.database:
            _dict['database'] = self.database.to_dict()
        # override the default output from pydantic by calling `to_dict()` of elastic
        if self.elastic:
            _dict['elastic'] = self.elastic.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rabbit
        if self.rabbit:
            _dict['rabbit'] = self.rabbit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Health from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "success": obj.get("success"),
            "statusMessage": obj.get("statusMessage"),
            "applianceUrl": obj.get("applianceUrl"),
            "buildVersion": obj.get("buildVersion"),
            "uuid": obj.get("uuid"),
            "setupNeeded": obj.get("setupNeeded"),
            "date": obj.get("date"),
            "cpu": ListHealth200ResponseAllOfHealthCpu.from_dict(obj["cpu"]) if obj.get("cpu") is not None else None,
            "memory": ListHealth200ResponseAllOfHealthMemory.from_dict(obj["memory"]) if obj.get("memory") is not None else None,
            "threads": ListHealth200ResponseAllOfHealthThreads.from_dict(obj["threads"]) if obj.get("threads") is not None else None,
            "database": ListHealth200ResponseAllOfHealthDatabase.from_dict(obj["database"]) if obj.get("database") is not None else None,
            "elastic": ListHealth200ResponseAllOfHealthElastic.from_dict(obj["elastic"]) if obj.get("elastic") is not None else None,
            "rabbit": ListHealth200ResponseAllOfHealthRabbit.from_dict(obj["rabbit"]) if obj.get("rabbit") is not None else None
        })
        return _obj


