# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_identity_sources200_response_all_of_user_sources_inner_any_of5_provider_settings import ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf5ProviderSettings
from morpheus.models.list_identity_sources200_response_all_of_user_sources_inner_any_of5_role_mappings_inner import ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf5RoleMappingsInner
from morpheus.models.list_identity_sources200_response_all_of_user_sources_inner_any_of6_config import ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf6Config
from morpheus.models.list_identity_sources200_response_all_of_user_sources_inner_any_of_default_account_role import ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOfDefaultAccountRole
from typing import Optional, Set
from typing_extensions import Self

class IdentitySourcesAzureADConfig(BaseModel):
    """
    IdentitySourcesAzureADConfig
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    deleted: Optional[StrictBool] = None
    auto_sync_on_login: Optional[StrictBool] = Field(default=None, alias="autoSyncOnLogin")
    external_login: Optional[StrictBool] = Field(default=None, alias="externalLogin")
    allow_custom_mappings: Optional[StrictBool] = Field(default=None, alias="allowCustomMappings")
    manual_role_assignment: Optional[StrictBool] = Field(default=None, alias="manualRoleAssignment")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    default_account_role: Optional[ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOfDefaultAccountRole] = Field(default=None, alias="defaultAccountRole")
    config: Optional[ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf6Config] = None
    role_mappings: Optional[List[ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf5RoleMappingsInner]] = Field(default=None, alias="roleMappings")
    subdomain: Optional[StrictStr] = None
    login_url: Optional[StrictStr] = Field(default=None, alias="loginURL")
    provider_settings: Optional[ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf5ProviderSettings] = Field(default=None, alias="providerSettings")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "code", "type", "active", "deleted", "autoSyncOnLogin", "externalLogin", "allowCustomMappings", "manualRoleAssignment", "account", "defaultAccountRole", "config", "roleMappings", "subdomain", "loginURL", "providerSettings", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdentitySourcesAzureADConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_account_role
        if self.default_account_role:
            _dict['defaultAccountRole'] = self.default_account_role.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in role_mappings (list)
        _items = []
        if self.role_mappings:
            for _item_role_mappings in self.role_mappings:
                if _item_role_mappings:
                    _items.append(_item_role_mappings.to_dict())
            _dict['roleMappings'] = _items
        # override the default output from pydantic by calling `to_dict()` of provider_settings
        if self.provider_settings:
            _dict['providerSettings'] = self.provider_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdentitySourcesAzureADConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "code": obj.get("code"),
            "type": obj.get("type"),
            "active": obj.get("active"),
            "deleted": obj.get("deleted"),
            "autoSyncOnLogin": obj.get("autoSyncOnLogin"),
            "externalLogin": obj.get("externalLogin"),
            "allowCustomMappings": obj.get("allowCustomMappings"),
            "manualRoleAssignment": obj.get("manualRoleAssignment"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "defaultAccountRole": ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOfDefaultAccountRole.from_dict(obj["defaultAccountRole"]) if obj.get("defaultAccountRole") is not None else None,
            "config": ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf6Config.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "roleMappings": [ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf5RoleMappingsInner.from_dict(_item) for _item in obj["roleMappings"]] if obj.get("roleMappings") is not None else None,
            "subdomain": obj.get("subdomain"),
            "loginURL": obj.get("loginURL"),
            "providerSettings": ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf5ProviderSettings.from_dict(obj["providerSettings"]) if obj.get("providerSettings") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


