# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_image_build_request_image_build_boot_script import AddImageBuildRequestImageBuildBootScript
from morpheus.models.add_image_build_request_image_build_preseed_script import AddImageBuildRequestImageBuildPreseedScript
from morpheus.models.add_image_build_request_image_build_site import AddImageBuildRequestImageBuildSite
from morpheus.models.add_image_build_request_image_build_zone import AddImageBuildRequestImageBuildZone
from typing import Optional, Set
from typing_extensions import Self

class ImageBuildCreate(BaseModel):
    """
    ImageBuildCreate
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A name for the image build")
    description: Optional[StrictStr] = Field(default=None, description="A description for the image build")
    type: Optional[StrictStr] = Field(default=None, description="The image builder type.")
    site: Optional[AddImageBuildRequestImageBuildSite] = None
    zone: Optional[AddImageBuildRequestImageBuildZone] = None
    config: Optional[Dict[str, Any]] = Field(default=None, description="A map of config values. This is the instance config that is used for provisioning. See Provisioning Types.")
    boot_script: Optional[AddImageBuildRequestImageBuildBootScript] = Field(default=None, alias="bootScript")
    preseed_script: Optional[AddImageBuildRequestImageBuildPreseedScript] = Field(default=None, alias="preseedScript")
    ssh_username: Optional[StrictStr] = Field(default=None, description="SSH Username", alias="sshUsername")
    ssh_password: Optional[StrictStr] = Field(default=None, description="SSH Password", alias="sshPassword")
    storage_provider: Optional[StrictStr] = Field(default=None, description="Storage Provider", alias="storageProvider")
    is_cloud_init: Optional[StrictStr] = Field(default=None, description="Cloud Init", alias="isCloudInit")
    build_output_name: Optional[StrictStr] = Field(default=None, description="Build Output Name", alias="buildOutputName")
    conversion_formats: Optional[StrictStr] = Field(default=None, alias="conversionFormats")
    keep_results: Optional[StrictInt] = Field(default=0, description="Keep Results - Keep only the most recent builds. Older executions will be deleted along with their associated Virtual Images. The value 0 disables this functionality.", alias="keepResults")
    __properties: ClassVar[List[str]] = ["name", "description", "type", "site", "zone", "config", "bootScript", "preseedScript", "sshUsername", "sshPassword", "storageProvider", "isCloudInit", "buildOutputName", "conversionFormats", "keepResults"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['vmware']):
            raise ValueError("must be one of enum values ('vmware')")
        return value

    @field_validator('conversion_formats')
    def conversion_formats_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ovf', 'qcow2', 'vhd']):
            raise ValueError("must be one of enum values ('ovf', 'qcow2', 'vhd')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImageBuildCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict['site'] = self.site.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of boot_script
        if self.boot_script:
            _dict['bootScript'] = self.boot_script.to_dict()
        # override the default output from pydantic by calling `to_dict()` of preseed_script
        if self.preseed_script:
            _dict['preseedScript'] = self.preseed_script.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if storage_provider (nullable) is None
        # and model_fields_set contains the field
        if self.storage_provider is None and "storage_provider" in self.model_fields_set:
            _dict['storageProvider'] = None

        # set to None if build_output_name (nullable) is None
        # and model_fields_set contains the field
        if self.build_output_name is None and "build_output_name" in self.model_fields_set:
            _dict['buildOutputName'] = None

        # set to None if conversion_formats (nullable) is None
        # and model_fields_set contains the field
        if self.conversion_formats is None and "conversion_formats" in self.model_fields_set:
            _dict['conversionFormats'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImageBuildCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "site": AddImageBuildRequestImageBuildSite.from_dict(obj["site"]) if obj.get("site") is not None else None,
            "zone": AddImageBuildRequestImageBuildZone.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "config": obj.get("config"),
            "bootScript": AddImageBuildRequestImageBuildBootScript.from_dict(obj["bootScript"]) if obj.get("bootScript") is not None else None,
            "preseedScript": AddImageBuildRequestImageBuildPreseedScript.from_dict(obj["preseedScript"]) if obj.get("preseedScript") is not None else None,
            "sshUsername": obj.get("sshUsername"),
            "sshPassword": obj.get("sshPassword"),
            "storageProvider": obj.get("storageProvider"),
            "isCloudInit": obj.get("isCloudInit"),
            "buildOutputName": obj.get("buildOutputName"),
            "conversionFormats": obj.get("conversionFormats"),
            "keepResults": obj.get("keepResults") if obj.get("keepResults") is not None else 0
        })
        return _obj


