# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_env_variables200_response_instance_envs_inner import GetEnvVariables200ResponseInstanceEnvsInner
from typing import Optional, Set
from typing_extensions import Self

class InstanceEnvs(BaseModel):
    """
    InstanceEnvs
    """ # noqa: E501
    envs: Optional[List[GetEnvVariables200ResponseInstanceEnvsInner]] = None
    read_only_envs: Optional[List[GetEnvVariables200ResponseInstanceEnvsInner]] = Field(default=None, alias="readOnlyEnvs")
    imported_envs: Optional[List[GetEnvVariables200ResponseInstanceEnvsInner]] = Field(default=None, alias="importedEnvs")
    __properties: ClassVar[List[str]] = ["envs", "readOnlyEnvs", "importedEnvs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InstanceEnvs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in envs (list)
        _items = []
        if self.envs:
            for _item_envs in self.envs:
                if _item_envs:
                    _items.append(_item_envs.to_dict())
            _dict['envs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in read_only_envs (list)
        _items = []
        if self.read_only_envs:
            for _item_read_only_envs in self.read_only_envs:
                if _item_read_only_envs:
                    _items.append(_item_read_only_envs.to_dict())
            _dict['readOnlyEnvs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in imported_envs (list)
        _items = []
        if self.imported_envs:
            for _item_imported_envs in self.imported_envs:
                if _item_imported_envs:
                    _items.append(_item_imported_envs.to_dict())
            _dict['importedEnvs'] = _items
        # set to None if envs (nullable) is None
        # and model_fields_set contains the field
        if self.envs is None and "envs" in self.model_fields_set:
            _dict['envs'] = None

        # set to None if read_only_envs (nullable) is None
        # and model_fields_set contains the field
        if self.read_only_envs is None and "read_only_envs" in self.model_fields_set:
            _dict['readOnlyEnvs'] = None

        # set to None if imported_envs (nullable) is None
        # and model_fields_set contains the field
        if self.imported_envs is None and "imported_envs" in self.model_fields_set:
            _dict['importedEnvs'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InstanceEnvs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "envs": [GetEnvVariables200ResponseInstanceEnvsInner.from_dict(_item) for _item in obj["envs"]] if obj.get("envs") is not None else None,
            "readOnlyEnvs": [GetEnvVariables200ResponseInstanceEnvsInner.from_dict(_item) for _item in obj["readOnlyEnvs"]] if obj.get("readOnlyEnvs") is not None else None,
            "importedEnvs": [GetEnvVariables200ResponseInstanceEnvsInner.from_dict(_item) for _item in obj["importedEnvs"]] if obj.get("importedEnvs") is not None else None
        })
        return _obj


