# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_invoices200_response_all_of_invoices_inner_cloud import ListInvoices200ResponseAllOfInvoicesInnerCloud
from morpheus.models.list_invoices200_response_all_of_invoices_inner_line_items_inner import ListInvoices200ResponseAllOfInvoicesInnerLineItemsInner
from typing import Optional, Set
from typing_extensions import Self

class Invoice(BaseModel):
    """
    Invoice
    """ # noqa: E501
    id: Optional[StrictInt] = None
    owner_id: Optional[StrictInt] = Field(default=None, alias="ownerId")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    group: Optional[Dict[str, Any]] = None
    cloud: Optional[ListInvoices200ResponseAllOfInvoicesInnerCloud] = None
    instance: Optional[Dict[str, Any]] = None
    server: Optional[StrictStr] = None
    cluster: Optional[StrictStr] = None
    user: Optional[Dict[str, Any]] = None
    plan: Optional[Dict[str, Any]] = None
    tags: Optional[List[Dict[str, Any]]] = None
    project: Optional[StrictStr] = None
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    ref_uuid: Optional[StrictStr] = Field(default=None, alias="refUuid")
    ref_name: Optional[StrictStr] = Field(default=None, alias="refName")
    ref_category: Optional[StrictStr] = Field(default=None, alias="refCategory")
    resource_id: Optional[StrictStr] = Field(default=None, alias="resourceId")
    resource_uuid: Optional[StrictStr] = Field(default=None, alias="resourceUuid")
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    resource_name: Optional[StrictStr] = Field(default=None, alias="resourceName")
    resource_external_id: Optional[StrictStr] = Field(default=None, alias="resourceExternalId")
    resource_internal_id: Optional[StrictStr] = Field(default=None, alias="resourceInternalId")
    interval: Optional[StrictStr] = None
    period: Optional[StrictStr] = None
    estimate: Optional[StrictBool] = None
    summary_invoice: Optional[StrictBool] = Field(default=None, alias="summaryInvoice")
    active: Optional[StrictBool] = None
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    ref_start: Optional[datetime] = Field(default=None, alias="refStart")
    ref_end: Optional[datetime] = Field(default=None, alias="refEnd")
    estimated_compute_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedComputePrice")
    estimated_compute_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedComputeCost")
    estimated_memory_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedMemoryPrice")
    estimated_memory_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedMemoryCost")
    estimated_storage_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedStoragePrice")
    estimated_storage_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedStorageCost")
    estimated_network_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedNetworkPrice")
    estimated_network_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedNetworkCost")
    estimated_license_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedLicensePrice")
    estimated_license_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedLicenseCost")
    estimated_extra_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedExtraPrice")
    estimated_extra_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedExtraCost")
    estimated_total_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedTotalPrice")
    estimated_total_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedTotalCost")
    estimated_running_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedRunningPrice")
    estimated_running_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedRunningCost")
    estimated_currency: Optional[StrictStr] = Field(default=None, alias="estimatedCurrency")
    estimated_conversion_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="estimatedConversionRate")
    actual_compute_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualComputePrice")
    actual_compute_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualComputeCost")
    actual_memory_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualMemoryPrice")
    actual_memory_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualMemoryCost")
    actual_storage_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualStoragePrice")
    actual_storage_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualStorageCost")
    actual_network_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualNetworkPrice")
    actual_network_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualNetworkCost")
    actual_license_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualLicensePrice")
    actual_license_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualLicenseCost")
    actual_extra_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualExtraPrice")
    actual_extra_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualExtraCost")
    actual_total_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualTotalPrice")
    actual_total_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualTotalCost")
    actual_running_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualRunningPrice")
    actual_running_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualRunningCost")
    actual_currency: Optional[StrictStr] = Field(default=None, alias="actualCurrency")
    actual_conversion_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="actualConversionRate")
    compute_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="computePrice")
    compute_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="computeCost")
    memory_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="memoryPrice")
    memory_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="memoryCost")
    storage_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="storagePrice")
    storage_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="storageCost")
    network_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="networkPrice")
    network_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="networkCost")
    license_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="licensePrice")
    license_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="licenseCost")
    extra_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="extraPrice")
    extra_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="extraCost")
    total_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalPrice")
    total_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalCost")
    running_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="runningPrice")
    running_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="runningCost")
    currency: Optional[StrictStr] = None
    conversion_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="conversionRate")
    cost_type: Optional[StrictStr] = Field(default=None, alias="costType")
    off_time: Optional[StrictInt] = Field(default=None, alias="offTime")
    power_state: Optional[StrictStr] = Field(default=None, alias="powerState")
    power_date: Optional[datetime] = Field(default=None, alias="powerDate")
    running_multiplier: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="runningMultiplier")
    usage_type: Optional[StrictStr] = Field(default=None, alias="usageType")
    usage_category: Optional[StrictStr] = Field(default=None, alias="usageCategory")
    last_cost_date: Optional[datetime] = Field(default=None, alias="lastCostDate")
    last_actual_date: Optional[datetime] = Field(default=None, alias="lastActualDate")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    line_item_count: Optional[StrictInt] = Field(default=None, alias="lineItemCount")
    line_items: Optional[List[ListInvoices200ResponseAllOfInvoicesInnerLineItemsInner]] = Field(default=None, alias="lineItems")
    __properties: ClassVar[List[str]] = ["id", "ownerId", "account", "group", "cloud", "instance", "server", "cluster", "user", "plan", "tags", "project", "refType", "refId", "refUuid", "refName", "refCategory", "resourceId", "resourceUuid", "resourceType", "resourceName", "resourceExternalId", "resourceInternalId", "interval", "period", "estimate", "summaryInvoice", "active", "startDate", "endDate", "refStart", "refEnd", "estimatedComputePrice", "estimatedComputeCost", "estimatedMemoryPrice", "estimatedMemoryCost", "estimatedStoragePrice", "estimatedStorageCost", "estimatedNetworkPrice", "estimatedNetworkCost", "estimatedLicensePrice", "estimatedLicenseCost", "estimatedExtraPrice", "estimatedExtraCost", "estimatedTotalPrice", "estimatedTotalCost", "estimatedRunningPrice", "estimatedRunningCost", "estimatedCurrency", "estimatedConversionRate", "actualComputePrice", "actualComputeCost", "actualMemoryPrice", "actualMemoryCost", "actualStoragePrice", "actualStorageCost", "actualNetworkPrice", "actualNetworkCost", "actualLicensePrice", "actualLicenseCost", "actualExtraPrice", "actualExtraCost", "actualTotalPrice", "actualTotalCost", "actualRunningPrice", "actualRunningCost", "actualCurrency", "actualConversionRate", "computePrice", "computeCost", "memoryPrice", "memoryCost", "storagePrice", "storageCost", "networkPrice", "networkCost", "licensePrice", "licenseCost", "extraPrice", "extraCost", "totalPrice", "totalCost", "runningPrice", "runningCost", "currency", "conversionRate", "costType", "offTime", "powerState", "powerDate", "runningMultiplier", "usageType", "usageCategory", "lastCostDate", "lastActualDate", "dateCreated", "lastUpdated", "lineItemCount", "lineItems"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Invoice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item_line_items in self.line_items:
                if _item_line_items:
                    _items.append(_item_line_items.to_dict())
            _dict['lineItems'] = _items
        # set to None if group (nullable) is None
        # and model_fields_set contains the field
        if self.group is None and "group" in self.model_fields_set:
            _dict['group'] = None

        # set to None if instance (nullable) is None
        # and model_fields_set contains the field
        if self.instance is None and "instance" in self.model_fields_set:
            _dict['instance'] = None

        # set to None if server (nullable) is None
        # and model_fields_set contains the field
        if self.server is None and "server" in self.model_fields_set:
            _dict['server'] = None

        # set to None if cluster (nullable) is None
        # and model_fields_set contains the field
        if self.cluster is None and "cluster" in self.model_fields_set:
            _dict['cluster'] = None

        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        # set to None if plan (nullable) is None
        # and model_fields_set contains the field
        if self.plan is None and "plan" in self.model_fields_set:
            _dict['plan'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if project (nullable) is None
        # and model_fields_set contains the field
        if self.project is None and "project" in self.model_fields_set:
            _dict['project'] = None

        # set to None if ref_uuid (nullable) is None
        # and model_fields_set contains the field
        if self.ref_uuid is None and "ref_uuid" in self.model_fields_set:
            _dict['refUuid'] = None

        # set to None if resource_id (nullable) is None
        # and model_fields_set contains the field
        if self.resource_id is None and "resource_id" in self.model_fields_set:
            _dict['resourceId'] = None

        # set to None if resource_uuid (nullable) is None
        # and model_fields_set contains the field
        if self.resource_uuid is None and "resource_uuid" in self.model_fields_set:
            _dict['resourceUuid'] = None

        # set to None if resource_type (nullable) is None
        # and model_fields_set contains the field
        if self.resource_type is None and "resource_type" in self.model_fields_set:
            _dict['resourceType'] = None

        # set to None if resource_name (nullable) is None
        # and model_fields_set contains the field
        if self.resource_name is None and "resource_name" in self.model_fields_set:
            _dict['resourceName'] = None

        # set to None if resource_external_id (nullable) is None
        # and model_fields_set contains the field
        if self.resource_external_id is None and "resource_external_id" in self.model_fields_set:
            _dict['resourceExternalId'] = None

        # set to None if resource_internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.resource_internal_id is None and "resource_internal_id" in self.model_fields_set:
            _dict['resourceInternalId'] = None

        # set to None if power_state (nullable) is None
        # and model_fields_set contains the field
        if self.power_state is None and "power_state" in self.model_fields_set:
            _dict['powerState'] = None

        # set to None if usage_type (nullable) is None
        # and model_fields_set contains the field
        if self.usage_type is None and "usage_type" in self.model_fields_set:
            _dict['usageType'] = None

        # set to None if usage_category (nullable) is None
        # and model_fields_set contains the field
        if self.usage_category is None and "usage_category" in self.model_fields_set:
            _dict['usageCategory'] = None

        # set to None if last_cost_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_cost_date is None and "last_cost_date" in self.model_fields_set:
            _dict['lastCostDate'] = None

        # set to None if last_actual_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_actual_date is None and "last_actual_date" in self.model_fields_set:
            _dict['lastActualDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Invoice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "ownerId": obj.get("ownerId"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "group": obj.get("group"),
            "cloud": ListInvoices200ResponseAllOfInvoicesInnerCloud.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "instance": obj.get("instance"),
            "server": obj.get("server"),
            "cluster": obj.get("cluster"),
            "user": obj.get("user"),
            "plan": obj.get("plan"),
            "tags": obj.get("tags"),
            "project": obj.get("project"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "refUuid": obj.get("refUuid"),
            "refName": obj.get("refName"),
            "refCategory": obj.get("refCategory"),
            "resourceId": obj.get("resourceId"),
            "resourceUuid": obj.get("resourceUuid"),
            "resourceType": obj.get("resourceType"),
            "resourceName": obj.get("resourceName"),
            "resourceExternalId": obj.get("resourceExternalId"),
            "resourceInternalId": obj.get("resourceInternalId"),
            "interval": obj.get("interval"),
            "period": obj.get("period"),
            "estimate": obj.get("estimate"),
            "summaryInvoice": obj.get("summaryInvoice"),
            "active": obj.get("active"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "refStart": obj.get("refStart"),
            "refEnd": obj.get("refEnd"),
            "estimatedComputePrice": obj.get("estimatedComputePrice"),
            "estimatedComputeCost": obj.get("estimatedComputeCost"),
            "estimatedMemoryPrice": obj.get("estimatedMemoryPrice"),
            "estimatedMemoryCost": obj.get("estimatedMemoryCost"),
            "estimatedStoragePrice": obj.get("estimatedStoragePrice"),
            "estimatedStorageCost": obj.get("estimatedStorageCost"),
            "estimatedNetworkPrice": obj.get("estimatedNetworkPrice"),
            "estimatedNetworkCost": obj.get("estimatedNetworkCost"),
            "estimatedLicensePrice": obj.get("estimatedLicensePrice"),
            "estimatedLicenseCost": obj.get("estimatedLicenseCost"),
            "estimatedExtraPrice": obj.get("estimatedExtraPrice"),
            "estimatedExtraCost": obj.get("estimatedExtraCost"),
            "estimatedTotalPrice": obj.get("estimatedTotalPrice"),
            "estimatedTotalCost": obj.get("estimatedTotalCost"),
            "estimatedRunningPrice": obj.get("estimatedRunningPrice"),
            "estimatedRunningCost": obj.get("estimatedRunningCost"),
            "estimatedCurrency": obj.get("estimatedCurrency"),
            "estimatedConversionRate": obj.get("estimatedConversionRate"),
            "actualComputePrice": obj.get("actualComputePrice"),
            "actualComputeCost": obj.get("actualComputeCost"),
            "actualMemoryPrice": obj.get("actualMemoryPrice"),
            "actualMemoryCost": obj.get("actualMemoryCost"),
            "actualStoragePrice": obj.get("actualStoragePrice"),
            "actualStorageCost": obj.get("actualStorageCost"),
            "actualNetworkPrice": obj.get("actualNetworkPrice"),
            "actualNetworkCost": obj.get("actualNetworkCost"),
            "actualLicensePrice": obj.get("actualLicensePrice"),
            "actualLicenseCost": obj.get("actualLicenseCost"),
            "actualExtraPrice": obj.get("actualExtraPrice"),
            "actualExtraCost": obj.get("actualExtraCost"),
            "actualTotalPrice": obj.get("actualTotalPrice"),
            "actualTotalCost": obj.get("actualTotalCost"),
            "actualRunningPrice": obj.get("actualRunningPrice"),
            "actualRunningCost": obj.get("actualRunningCost"),
            "actualCurrency": obj.get("actualCurrency"),
            "actualConversionRate": obj.get("actualConversionRate"),
            "computePrice": obj.get("computePrice"),
            "computeCost": obj.get("computeCost"),
            "memoryPrice": obj.get("memoryPrice"),
            "memoryCost": obj.get("memoryCost"),
            "storagePrice": obj.get("storagePrice"),
            "storageCost": obj.get("storageCost"),
            "networkPrice": obj.get("networkPrice"),
            "networkCost": obj.get("networkCost"),
            "licensePrice": obj.get("licensePrice"),
            "licenseCost": obj.get("licenseCost"),
            "extraPrice": obj.get("extraPrice"),
            "extraCost": obj.get("extraCost"),
            "totalPrice": obj.get("totalPrice"),
            "totalCost": obj.get("totalCost"),
            "runningPrice": obj.get("runningPrice"),
            "runningCost": obj.get("runningCost"),
            "currency": obj.get("currency"),
            "conversionRate": obj.get("conversionRate"),
            "costType": obj.get("costType"),
            "offTime": obj.get("offTime"),
            "powerState": obj.get("powerState"),
            "powerDate": obj.get("powerDate"),
            "runningMultiplier": obj.get("runningMultiplier"),
            "usageType": obj.get("usageType"),
            "usageCategory": obj.get("usageCategory"),
            "lastCostDate": obj.get("lastCostDate"),
            "lastActualDate": obj.get("lastActualDate"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "lineItemCount": obj.get("lineItemCount"),
            "lineItems": [ListInvoices200ResponseAllOfInvoicesInnerLineItemsInner.from_dict(_item) for _item in obj["lineItems"]] if obj.get("lineItems") is not None else None
        })
        return _obj


