# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from typing import Optional, Set
from typing_extensions import Self

class ListActivity200ResponseAllOfActivityInnerActivityInner(BaseModel):
    """
    ListActivity200ResponseAllOfActivityInnerActivityInner
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="_id")
    success: Optional[StrictBool] = None
    activity_type: Optional[StrictStr] = Field(default=None, alias="activityType")
    name: Optional[StrictStr] = None
    message: Optional[StrictStr] = None
    object_type: Optional[StrictStr] = Field(default=None, alias="objectType")
    object_id: Optional[StrictInt] = Field(default=None, alias="objectId")
    user: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = None
    ts: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["_id", "success", "activityType", "name", "message", "objectType", "objectId", "user", "ts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListActivity200ResponseAllOfActivityInnerActivityInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListActivity200ResponseAllOfActivityInnerActivityInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "success": obj.get("success"),
            "activityType": obj.get("activityType"),
            "name": obj.get("name"),
            "message": obj.get("message"),
            "objectType": obj.get("objectType"),
            "objectId": obj.get("objectId"),
            "user": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "ts": obj.get("ts")
        })
        return _obj


