# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_backup_jobs200_response_all_of_jobs_inner_backups_inner import ListBackupJobs200ResponseAllOfJobsInnerBackupsInner
from morpheus.models.list_backup_restores200_response_all_of_restores_inner_container import ListBackupRestores200ResponseAllOfRestoresInnerContainer
from morpheus.models.list_backups200_response_all_of_backups_inner_instance import ListBackups200ResponseAllOfBackupsInnerInstance
from typing import Optional, Set
from typing_extensions import Self

class ListBackupRestores200ResponseAllOfRestoresInner(BaseModel):
    """
    ListBackupRestores200ResponseAllOfRestoresInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Backup Result ID")
    backup_result_id: Optional[StrictInt] = Field(default=None, alias="backupResultId")
    backup_id: Optional[StrictInt] = Field(default=None, alias="backupId")
    backup: Optional[ListBackupJobs200ResponseAllOfJobsInnerBackupsInner] = None
    container_id: Optional[StrictInt] = Field(default=None, alias="containerId")
    container: Optional[ListBackupRestores200ResponseAllOfRestoresInnerContainer] = None
    instance: Optional[ListBackups200ResponseAllOfBackupsInnerInstance] = None
    restore_to_new: Optional[StrictBool] = Field(default=None, alias="restoreToNew")
    status: Optional[StrictStr] = None
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    duration_millis: Optional[StrictInt] = Field(default=None, alias="durationMillis")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    external_status_ref: Optional[StrictStr] = Field(default=None, alias="externalStatusRef")
    date_created: Optional[datetime] = Field(default=None, description="Date Created", alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, description="Last Updated", alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "backupResultId", "backupId", "backup", "containerId", "container", "instance", "restoreToNew", "status", "errorMessage", "startDate", "endDate", "durationMillis", "externalId", "externalStatusRef", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListBackupRestores200ResponseAllOfRestoresInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of backup
        if self.backup:
            _dict['backup'] = self.backup.to_dict()
        # override the default output from pydantic by calling `to_dict()` of container
        if self.container:
            _dict['container'] = self.container.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instance
        if self.instance:
            _dict['instance'] = self.instance.to_dict()
        # set to None if container_id (nullable) is None
        # and model_fields_set contains the field
        if self.container_id is None and "container_id" in self.model_fields_set:
            _dict['containerId'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['errorMessage'] = None

        # set to None if start_date (nullable) is None
        # and model_fields_set contains the field
        if self.start_date is None and "start_date" in self.model_fields_set:
            _dict['startDate'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['endDate'] = None

        # set to None if duration_millis (nullable) is None
        # and model_fields_set contains the field
        if self.duration_millis is None and "duration_millis" in self.model_fields_set:
            _dict['durationMillis'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if external_status_ref (nullable) is None
        # and model_fields_set contains the field
        if self.external_status_ref is None and "external_status_ref" in self.model_fields_set:
            _dict['externalStatusRef'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListBackupRestores200ResponseAllOfRestoresInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "backupResultId": obj.get("backupResultId"),
            "backupId": obj.get("backupId"),
            "backup": ListBackupJobs200ResponseAllOfJobsInnerBackupsInner.from_dict(obj["backup"]) if obj.get("backup") is not None else None,
            "containerId": obj.get("containerId"),
            "container": ListBackupRestores200ResponseAllOfRestoresInnerContainer.from_dict(obj["container"]) if obj.get("container") is not None else None,
            "instance": ListBackups200ResponseAllOfBackupsInnerInstance.from_dict(obj["instance"]) if obj.get("instance") is not None else None,
            "restoreToNew": obj.get("restoreToNew"),
            "status": obj.get("status"),
            "errorMessage": obj.get("errorMessage"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "durationMillis": obj.get("durationMillis"),
            "externalId": obj.get("externalId"),
            "externalStatusRef": obj.get("externalStatusRef"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


