# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_backups200_response_all_of_backups_inner_backup_provider import ListBackups200ResponseAllOfBackupsInnerBackupProvider
from morpheus.models.list_backups200_response_all_of_backups_inner_backup_respository import ListBackups200ResponseAllOfBackupsInnerBackupRespository
from morpheus.models.list_backups200_response_all_of_backups_inner_backup_type import ListBackups200ResponseAllOfBackupsInnerBackupType
from morpheus.models.list_backups200_response_all_of_backups_inner_instance import ListBackups200ResponseAllOfBackupsInnerInstance
from morpheus.models.list_backups200_response_all_of_backups_inner_job import ListBackups200ResponseAllOfBackupsInnerJob
from morpheus.models.list_backups200_response_all_of_backups_inner_last_result import ListBackups200ResponseAllOfBackupsInnerLastResult
from morpheus.models.list_backups200_response_all_of_backups_inner_schedule import ListBackups200ResponseAllOfBackupsInnerSchedule
from morpheus.models.list_backups200_response_all_of_backups_inner_stats import ListBackups200ResponseAllOfBackupsInnerStats
from morpheus.models.list_backups200_response_all_of_backups_inner_storage_provider import ListBackups200ResponseAllOfBackupsInnerStorageProvider
from typing import Optional, Set
from typing_extensions import Self

class ListBackups200ResponseAllOfBackupsInner(BaseModel):
    """
    ListBackups200ResponseAllOfBackupsInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Backup ID")
    name: Optional[StrictStr] = Field(default=None, description="Name")
    location_type: Optional[StrictStr] = Field(default=None, description="Source Type (instance, server, storage)", alias="locationType")
    instance: Optional[ListBackups200ResponseAllOfBackupsInnerInstance] = None
    container_id: Optional[StrictInt] = Field(default=None, alias="containerId")
    job: Optional[ListBackups200ResponseAllOfBackupsInnerJob] = None
    schedule: Optional[ListBackups200ResponseAllOfBackupsInnerSchedule] = None
    retention_count: Optional[StrictInt] = Field(default=None, alias="retentionCount")
    backup_type: Optional[ListBackups200ResponseAllOfBackupsInnerBackupType] = Field(default=None, alias="backupType")
    storage_provider: Optional[ListBackups200ResponseAllOfBackupsInnerStorageProvider] = Field(default=None, alias="storageProvider")
    backup_provider: Optional[ListBackups200ResponseAllOfBackupsInnerBackupProvider] = Field(default=None, alias="backupProvider")
    backup_respository: Optional[ListBackups200ResponseAllOfBackupsInnerBackupRespository] = Field(default=None, alias="backupRespository")
    cron_expression: Optional[StrictStr] = Field(default=None, description="Cron Expression", alias="cronExpression")
    next_fire: Optional[datetime] = Field(default=None, description="Next Fire", alias="nextFire")
    last_status: Optional[StrictStr] = Field(default=None, description="Last Status", alias="lastStatus")
    last_result: Optional[ListBackups200ResponseAllOfBackupsInnerLastResult] = Field(default=None, alias="lastResult")
    stats: Optional[ListBackups200ResponseAllOfBackupsInnerStats] = None
    enabled: Optional[StrictBool] = Field(default=None, description="Enabled")
    date_created: Optional[datetime] = Field(default=None, description="Date Created", alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, description="Last Updated", alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "name", "locationType", "instance", "containerId", "job", "schedule", "retentionCount", "backupType", "storageProvider", "backupProvider", "backupRespository", "cronExpression", "nextFire", "lastStatus", "lastResult", "stats", "enabled", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListBackups200ResponseAllOfBackupsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of instance
        if self.instance:
            _dict['instance'] = self.instance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job
        if self.job:
            _dict['job'] = self.job.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict['schedule'] = self.schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of backup_type
        if self.backup_type:
            _dict['backupType'] = self.backup_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of storage_provider
        if self.storage_provider:
            _dict['storageProvider'] = self.storage_provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of backup_provider
        if self.backup_provider:
            _dict['backupProvider'] = self.backup_provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of backup_respository
        if self.backup_respository:
            _dict['backupRespository'] = self.backup_respository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_result
        if self.last_result:
            _dict['lastResult'] = self.last_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stats
        if self.stats:
            _dict['stats'] = self.stats.to_dict()
        # set to None if container_id (nullable) is None
        # and model_fields_set contains the field
        if self.container_id is None and "container_id" in self.model_fields_set:
            _dict['containerId'] = None

        # set to None if retention_count (nullable) is None
        # and model_fields_set contains the field
        if self.retention_count is None and "retention_count" in self.model_fields_set:
            _dict['retentionCount'] = None

        # set to None if cron_expression (nullable) is None
        # and model_fields_set contains the field
        if self.cron_expression is None and "cron_expression" in self.model_fields_set:
            _dict['cronExpression'] = None

        # set to None if next_fire (nullable) is None
        # and model_fields_set contains the field
        if self.next_fire is None and "next_fire" in self.model_fields_set:
            _dict['nextFire'] = None

        # set to None if last_status (nullable) is None
        # and model_fields_set contains the field
        if self.last_status is None and "last_status" in self.model_fields_set:
            _dict['lastStatus'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListBackups200ResponseAllOfBackupsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "locationType": obj.get("locationType"),
            "instance": ListBackups200ResponseAllOfBackupsInnerInstance.from_dict(obj["instance"]) if obj.get("instance") is not None else None,
            "containerId": obj.get("containerId"),
            "job": ListBackups200ResponseAllOfBackupsInnerJob.from_dict(obj["job"]) if obj.get("job") is not None else None,
            "schedule": ListBackups200ResponseAllOfBackupsInnerSchedule.from_dict(obj["schedule"]) if obj.get("schedule") is not None else None,
            "retentionCount": obj.get("retentionCount"),
            "backupType": ListBackups200ResponseAllOfBackupsInnerBackupType.from_dict(obj["backupType"]) if obj.get("backupType") is not None else None,
            "storageProvider": ListBackups200ResponseAllOfBackupsInnerStorageProvider.from_dict(obj["storageProvider"]) if obj.get("storageProvider") is not None else None,
            "backupProvider": ListBackups200ResponseAllOfBackupsInnerBackupProvider.from_dict(obj["backupProvider"]) if obj.get("backupProvider") is not None else None,
            "backupRespository": ListBackups200ResponseAllOfBackupsInnerBackupRespository.from_dict(obj["backupRespository"]) if obj.get("backupRespository") is not None else None,
            "cronExpression": obj.get("cronExpression"),
            "nextFire": obj.get("nextFire"),
            "lastStatus": obj.get("lastStatus"),
            "lastResult": ListBackups200ResponseAllOfBackupsInnerLastResult.from_dict(obj["lastResult"]) if obj.get("lastResult") is not None else None,
            "stats": ListBackups200ResponseAllOfBackupsInnerStats.from_dict(obj["stats"]) if obj.get("stats") is not None else None,
            "enabled": obj.get("enabled"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


