# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_cloud_types200_response_all_of_zone_types_inner_option_types_inner import ListCloudTypes200ResponseAllOfZoneTypesInnerOptionTypesInner
from morpheus.models.list_cloud_types200_response_all_of_zone_types_inner_server_types_inner import ListCloudTypes200ResponseAllOfZoneTypesInnerServerTypesInner
from typing import Optional, Set
from typing_extensions import Self

class ListCloudTypes200ResponseAllOfZoneTypesInner(BaseModel):
    """
    ListCloudTypes200ResponseAllOfZoneTypesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    provision: Optional[StrictBool] = None
    auto_capacity: Optional[StrictBool] = Field(default=None, alias="autoCapacity")
    migration_target: Optional[StrictBool] = Field(default=None, alias="migrationTarget")
    has_datastores: Optional[StrictBool] = Field(default=None, alias="hasDatastores")
    has_networks: Optional[StrictBool] = Field(default=None, alias="hasNetworks")
    has_resource_pools: Optional[StrictBool] = Field(default=None, alias="hasResourcePools")
    has_security_groups: Optional[StrictBool] = Field(default=None, alias="hasSecurityGroups")
    has_containers: Optional[StrictBool] = Field(default=None, alias="hasContainers")
    has_bare_metal: Optional[StrictBool] = Field(default=None, alias="hasBareMetal")
    has_services: Optional[StrictBool] = Field(default=None, alias="hasServices")
    has_functions: Optional[StrictBool] = Field(default=None, alias="hasFunctions")
    has_jobs: Optional[StrictBool] = Field(default=None, alias="hasJobs")
    has_discovery: Optional[StrictBool] = Field(default=None, alias="hasDiscovery")
    has_cloud_init: Optional[StrictBool] = Field(default=None, alias="hasCloudInit")
    has_folders: Optional[StrictBool] = Field(default=None, alias="hasFolders")
    has_marketplace: Optional[StrictBool] = Field(default=None, alias="hasMarketplace")
    has_native_plans: Optional[StrictBool] = Field(default=None, alias="hasNativePlans")
    can_create_resource_pools: Optional[StrictBool] = Field(default=None, alias="canCreateResourcePools")
    can_delete_resource_pools: Optional[StrictBool] = Field(default=None, alias="canDeleteResourcePools")
    can_create_datastores: Optional[StrictBool] = Field(default=None, alias="canCreateDatastores")
    can_create_networks: Optional[StrictBool] = Field(default=None, alias="canCreateNetworks")
    can_choose_container_mode: Optional[StrictBool] = Field(default=None, alias="canChooseContainerMode")
    provision_requires_resource_pool: Optional[StrictBool] = Field(default=None, alias="provisionRequiresResourcePool")
    supports_distributed_worker: Optional[StrictBool] = Field(default=None, alias="supportsDistributedWorker")
    cloud: Optional[StrictStr] = None
    provision_types: Optional[List[StrictInt]] = Field(default=None, alias="provisionTypes")
    zone_instance_type_layout_id: Optional[StrictInt] = Field(default=None, alias="zoneInstanceTypeLayoutId")
    server_types: Optional[List[ListCloudTypes200ResponseAllOfZoneTypesInnerServerTypesInner]] = Field(default=None, alias="serverTypes")
    option_types: Optional[List[ListCloudTypes200ResponseAllOfZoneTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    __properties: ClassVar[List[str]] = ["id", "name", "code", "enabled", "provision", "autoCapacity", "migrationTarget", "hasDatastores", "hasNetworks", "hasResourcePools", "hasSecurityGroups", "hasContainers", "hasBareMetal", "hasServices", "hasFunctions", "hasJobs", "hasDiscovery", "hasCloudInit", "hasFolders", "hasMarketplace", "hasNativePlans", "canCreateResourcePools", "canDeleteResourcePools", "canCreateDatastores", "canCreateNetworks", "canChooseContainerMode", "provisionRequiresResourcePool", "supportsDistributedWorker", "cloud", "provisionTypes", "zoneInstanceTypeLayoutId", "serverTypes", "optionTypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListCloudTypes200ResponseAllOfZoneTypesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in server_types (list)
        _items = []
        if self.server_types:
            for _item_server_types in self.server_types:
                if _item_server_types:
                    _items.append(_item_server_types.to_dict())
            _dict['serverTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListCloudTypes200ResponseAllOfZoneTypesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "enabled": obj.get("enabled"),
            "provision": obj.get("provision"),
            "autoCapacity": obj.get("autoCapacity"),
            "migrationTarget": obj.get("migrationTarget"),
            "hasDatastores": obj.get("hasDatastores"),
            "hasNetworks": obj.get("hasNetworks"),
            "hasResourcePools": obj.get("hasResourcePools"),
            "hasSecurityGroups": obj.get("hasSecurityGroups"),
            "hasContainers": obj.get("hasContainers"),
            "hasBareMetal": obj.get("hasBareMetal"),
            "hasServices": obj.get("hasServices"),
            "hasFunctions": obj.get("hasFunctions"),
            "hasJobs": obj.get("hasJobs"),
            "hasDiscovery": obj.get("hasDiscovery"),
            "hasCloudInit": obj.get("hasCloudInit"),
            "hasFolders": obj.get("hasFolders"),
            "hasMarketplace": obj.get("hasMarketplace"),
            "hasNativePlans": obj.get("hasNativePlans"),
            "canCreateResourcePools": obj.get("canCreateResourcePools"),
            "canDeleteResourcePools": obj.get("canDeleteResourcePools"),
            "canCreateDatastores": obj.get("canCreateDatastores"),
            "canCreateNetworks": obj.get("canCreateNetworks"),
            "canChooseContainerMode": obj.get("canChooseContainerMode"),
            "provisionRequiresResourcePool": obj.get("provisionRequiresResourcePool"),
            "supportsDistributedWorker": obj.get("supportsDistributedWorker"),
            "cloud": obj.get("cloud"),
            "provisionTypes": obj.get("provisionTypes"),
            "zoneInstanceTypeLayoutId": obj.get("zoneInstanceTypeLayoutId"),
            "serverTypes": [ListCloudTypes200ResponseAllOfZoneTypesInnerServerTypesInner.from_dict(_item) for _item in obj["serverTypes"]] if obj.get("serverTypes") is not None else None,
            "optionTypes": [ListCloudTypes200ResponseAllOfZoneTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None
        })
        return _obj


