# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_cluster_containers200_response_all_of_containers_inner_available_actions_inner import ListClusterContainers200ResponseAllOfContainersInnerAvailableActionsInner
from morpheus.models.list_cluster_containers200_response_all_of_containers_inner_container_type import ListClusterContainers200ResponseAllOfContainersInnerContainerType
from morpheus.models.list_cluster_containers200_response_all_of_containers_inner_container_type_set import ListClusterContainers200ResponseAllOfContainersInnerContainerTypeSet
from morpheus.models.list_cluster_containers200_response_all_of_containers_inner_plan import ListClusterContainers200ResponseAllOfContainersInnerPlan
from morpheus.models.list_cluster_containers200_response_all_of_containers_inner_stats import ListClusterContainers200ResponseAllOfContainersInnerStats
from typing import Optional, Set
from typing_extensions import Self

class ListClusterContainers200ResponseAllOfContainersInner(BaseModel):
    """
    ListClusterContainers200ResponseAllOfContainersInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    uuid: Optional[StrictStr] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    instance: Optional[StrictStr] = None
    container_type: Optional[ListClusterContainers200ResponseAllOfContainersInnerContainerType] = Field(default=None, alias="containerType")
    container_type_set: Optional[ListClusterContainers200ResponseAllOfContainersInnerContainerTypeSet] = Field(default=None, alias="containerTypeSet")
    server: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    cloud: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    name: Optional[StrictStr] = None
    ip: Optional[StrictStr] = None
    internal_ip: Optional[StrictStr] = Field(default=None, alias="internalIp")
    internal_hostname: Optional[StrictStr] = Field(default=None, alias="internalHostname")
    external_hostname: Optional[StrictStr] = Field(default=None, alias="externalHostname")
    external_domain: Optional[StrictStr] = Field(default=None, alias="externalDomain")
    external_fqdn: Optional[StrictStr] = Field(default=None, alias="externalFqdn")
    ports: Optional[List[Dict[str, Any]]] = None
    plan: Optional[ListClusterContainers200ResponseAllOfContainersInnerPlan] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    stats_enabled: Optional[StrictBool] = Field(default=None, alias="statsEnabled")
    status: Optional[StrictStr] = None
    user_status: Optional[StrictStr] = Field(default=None, alias="userStatus")
    environment_prefix: Optional[StrictStr] = Field(default=None, alias="environmentPrefix")
    config_group: Optional[StrictStr] = Field(default=None, alias="configGroup")
    config_id: Optional[StrictStr] = Field(default=None, alias="configId")
    config_role: Optional[StrictStr] = Field(default=None, alias="configRole")
    stats: Optional[ListClusterContainers200ResponseAllOfContainersInnerStats] = None
    runtime_info: Optional[Dict[str, Any]] = Field(default=None, alias="runtimeInfo")
    container_version: Optional[StrictStr] = Field(default=None, alias="containerVersion")
    repository_image: Optional[StrictStr] = Field(default=None, alias="repositoryImage")
    plan_category: Optional[StrictStr] = Field(default=None, alias="planCategory")
    hostname: Optional[StrictStr] = None
    domain_name: Optional[StrictStr] = Field(default=None, alias="domainName")
    volume_created: Optional[StrictBool] = Field(default=None, alias="volumeCreated")
    container_created: Optional[StrictBool] = Field(default=None, alias="containerCreated")
    max_storage: Optional[StrictStr] = Field(default=None, alias="maxStorage")
    max_memory: Optional[StrictStr] = Field(default=None, alias="maxMemory")
    max_cores: Optional[StrictStr] = Field(default=None, alias="maxCores")
    max_cpu: Optional[StrictStr] = Field(default=None, alias="maxCpu")
    hourly_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="hourlyPrice")
    available_actions: Optional[List[ListClusterContainers200ResponseAllOfContainersInnerAvailableActionsInner]] = Field(default=None, alias="availableActions")
    __properties: ClassVar[List[str]] = ["id", "uuid", "accountId", "instance", "containerType", "containerTypeSet", "server", "cloud", "name", "ip", "internalIp", "internalHostname", "externalHostname", "externalDomain", "externalFqdn", "ports", "plan", "dateCreated", "lastUpdated", "statsEnabled", "status", "userStatus", "environmentPrefix", "configGroup", "configId", "configRole", "stats", "runtimeInfo", "containerVersion", "repositoryImage", "planCategory", "hostname", "domainName", "volumeCreated", "containerCreated", "maxStorage", "maxMemory", "maxCores", "maxCpu", "hourlyPrice", "availableActions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClusterContainers200ResponseAllOfContainersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of container_type
        if self.container_type:
            _dict['containerType'] = self.container_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of container_type_set
        if self.container_type_set:
            _dict['containerTypeSet'] = self.container_type_set.to_dict()
        # override the default output from pydantic by calling `to_dict()` of server
        if self.server:
            _dict['server'] = self.server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cloud
        if self.cloud:
            _dict['cloud'] = self.cloud.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stats
        if self.stats:
            _dict['stats'] = self.stats.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in available_actions (list)
        _items = []
        if self.available_actions:
            for _item_available_actions in self.available_actions:
                if _item_available_actions:
                    _items.append(_item_available_actions.to_dict())
            _dict['availableActions'] = _items
        # set to None if instance (nullable) is None
        # and model_fields_set contains the field
        if self.instance is None and "instance" in self.model_fields_set:
            _dict['instance'] = None

        # set to None if date_created (nullable) is None
        # and model_fields_set contains the field
        if self.date_created is None and "date_created" in self.model_fields_set:
            _dict['dateCreated'] = None

        # set to None if environment_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.environment_prefix is None and "environment_prefix" in self.model_fields_set:
            _dict['environmentPrefix'] = None

        # set to None if config_group (nullable) is None
        # and model_fields_set contains the field
        if self.config_group is None and "config_group" in self.model_fields_set:
            _dict['configGroup'] = None

        # set to None if config_id (nullable) is None
        # and model_fields_set contains the field
        if self.config_id is None and "config_id" in self.model_fields_set:
            _dict['configId'] = None

        # set to None if config_role (nullable) is None
        # and model_fields_set contains the field
        if self.config_role is None and "config_role" in self.model_fields_set:
            _dict['configRole'] = None

        # set to None if container_version (nullable) is None
        # and model_fields_set contains the field
        if self.container_version is None and "container_version" in self.model_fields_set:
            _dict['containerVersion'] = None

        # set to None if repository_image (nullable) is None
        # and model_fields_set contains the field
        if self.repository_image is None and "repository_image" in self.model_fields_set:
            _dict['repositoryImage'] = None

        # set to None if plan_category (nullable) is None
        # and model_fields_set contains the field
        if self.plan_category is None and "plan_category" in self.model_fields_set:
            _dict['planCategory'] = None

        # set to None if hostname (nullable) is None
        # and model_fields_set contains the field
        if self.hostname is None and "hostname" in self.model_fields_set:
            _dict['hostname'] = None

        # set to None if domain_name (nullable) is None
        # and model_fields_set contains the field
        if self.domain_name is None and "domain_name" in self.model_fields_set:
            _dict['domainName'] = None

        # set to None if max_storage (nullable) is None
        # and model_fields_set contains the field
        if self.max_storage is None and "max_storage" in self.model_fields_set:
            _dict['maxStorage'] = None

        # set to None if max_memory (nullable) is None
        # and model_fields_set contains the field
        if self.max_memory is None and "max_memory" in self.model_fields_set:
            _dict['maxMemory'] = None

        # set to None if max_cores (nullable) is None
        # and model_fields_set contains the field
        if self.max_cores is None and "max_cores" in self.model_fields_set:
            _dict['maxCores'] = None

        # set to None if max_cpu (nullable) is None
        # and model_fields_set contains the field
        if self.max_cpu is None and "max_cpu" in self.model_fields_set:
            _dict['maxCpu'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClusterContainers200ResponseAllOfContainersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "uuid": obj.get("uuid"),
            "accountId": obj.get("accountId"),
            "instance": obj.get("instance"),
            "containerType": ListClusterContainers200ResponseAllOfContainersInnerContainerType.from_dict(obj["containerType"]) if obj.get("containerType") is not None else None,
            "containerTypeSet": ListClusterContainers200ResponseAllOfContainersInnerContainerTypeSet.from_dict(obj["containerTypeSet"]) if obj.get("containerTypeSet") is not None else None,
            "server": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["server"]) if obj.get("server") is not None else None,
            "cloud": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["cloud"]) if obj.get("cloud") is not None else None,
            "name": obj.get("name"),
            "ip": obj.get("ip"),
            "internalIp": obj.get("internalIp"),
            "internalHostname": obj.get("internalHostname"),
            "externalHostname": obj.get("externalHostname"),
            "externalDomain": obj.get("externalDomain"),
            "externalFqdn": obj.get("externalFqdn"),
            "ports": obj.get("ports"),
            "plan": ListClusterContainers200ResponseAllOfContainersInnerPlan.from_dict(obj["plan"]) if obj.get("plan") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "statsEnabled": obj.get("statsEnabled"),
            "status": obj.get("status"),
            "userStatus": obj.get("userStatus"),
            "environmentPrefix": obj.get("environmentPrefix"),
            "configGroup": obj.get("configGroup"),
            "configId": obj.get("configId"),
            "configRole": obj.get("configRole"),
            "stats": ListClusterContainers200ResponseAllOfContainersInnerStats.from_dict(obj["stats"]) if obj.get("stats") is not None else None,
            "runtimeInfo": obj.get("runtimeInfo"),
            "containerVersion": obj.get("containerVersion"),
            "repositoryImage": obj.get("repositoryImage"),
            "planCategory": obj.get("planCategory"),
            "hostname": obj.get("hostname"),
            "domainName": obj.get("domainName"),
            "volumeCreated": obj.get("volumeCreated"),
            "containerCreated": obj.get("containerCreated"),
            "maxStorage": obj.get("maxStorage"),
            "maxMemory": obj.get("maxMemory"),
            "maxCores": obj.get("maxCores"),
            "maxCpu": obj.get("maxCpu"),
            "hourlyPrice": obj.get("hourlyPrice"),
            "availableActions": [ListClusterContainers200ResponseAllOfContainersInnerAvailableActionsInner.from_dict(_item) for _item in obj["availableActions"]] if obj.get("availableActions") is not None else None
        })
        return _obj


