# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerContainerType(BaseModel):
    """
    ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerContainerType
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    short_name: Optional[StrictStr] = Field(default=None, alias="shortName")
    code: Optional[StrictStr] = None
    container_version: Optional[StrictStr] = Field(default=None, alias="containerVersion")
    provision_type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="provisionType")
    virtual_image: Optional[StrictStr] = Field(default=None, alias="virtualImage")
    category: Optional[StrictStr] = None
    config: Optional[Dict[str, Any]] = None
    container_ports: Optional[List[Dict[str, Any]]] = Field(default=None, alias="containerPorts")
    container_scripts: Optional[List[Dict[str, Any]]] = Field(default=None, alias="containerScripts")
    container_templates: Optional[List[Dict[str, Any]]] = Field(default=None, alias="containerTemplates")
    environment_variables: Optional[List[Dict[str, Any]]] = Field(default=None, alias="environmentVariables")
    __properties: ClassVar[List[str]] = ["id", "account", "name", "labels", "shortName", "code", "containerVersion", "provisionType", "virtualImage", "category", "config", "containerPorts", "containerScripts", "containerTemplates", "environmentVariables"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerContainerType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provision_type
        if self.provision_type:
            _dict['provisionType'] = self.provision_type.to_dict()
        # set to None if account (nullable) is None
        # and model_fields_set contains the field
        if self.account is None and "account" in self.model_fields_set:
            _dict['account'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if virtual_image (nullable) is None
        # and model_fields_set contains the field
        if self.virtual_image is None and "virtual_image" in self.model_fields_set:
            _dict['virtualImage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClusterLayouts200ResponseAllOfLayoutsInnerComputeServersInnerContainerType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account": obj.get("account"),
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "shortName": obj.get("shortName"),
            "code": obj.get("code"),
            "containerVersion": obj.get("containerVersion"),
            "provisionType": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["provisionType"]) if obj.get("provisionType") is not None else None,
            "virtualImage": obj.get("virtualImage"),
            "category": obj.get("category"),
            "config": obj.get("config"),
            "containerPorts": obj.get("containerPorts"),
            "containerScripts": obj.get("containerScripts"),
            "containerTemplates": obj.get("containerTemplates"),
            "environmentVariables": obj.get("environmentVariables")
        })
        return _obj


