# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from morpheus.models.list_clusters200_response_all_of_clusters_inner_layout import ListClusters200ResponseAllOfClustersInnerLayout
from morpheus.models.list_clusters200_response_all_of_clusters_inner_servers_inner import ListClusters200ResponseAllOfClustersInnerServersInner
from morpheus.models.list_clusters200_response_all_of_clusters_inner_worker_stats import ListClusters200ResponseAllOfClustersInnerWorkerStats
from morpheus.models.list_clusters200_response_all_of_clusters_inner_zone import ListClusters200ResponseAllOfClustersInnerZone
from typing import Optional, Set
from typing_extensions import Self

class ListClusters200ResponseAllOfClustersInner(BaseModel):
    """
    ListClusters200ResponseAllOfClustersInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    location: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    service_url: Optional[StrictStr] = Field(default=None, alias="serviceUrl")
    service_host: Optional[StrictStr] = Field(default=None, alias="serviceHost")
    service_path: Optional[StrictStr] = Field(default=None, alias="servicePath")
    service_hostname: Optional[StrictStr] = Field(default=None, alias="serviceHostname")
    service_port: Optional[StrictInt] = Field(default=None, alias="servicePort")
    service_username: Optional[StrictStr] = Field(default=None, alias="serviceUsername")
    service_password: Optional[StrictStr] = Field(default=None, alias="servicePassword")
    service_password_hash: Optional[StrictStr] = Field(default=None, alias="servicePasswordHash")
    service_token: Optional[StrictStr] = Field(default=None, alias="serviceToken")
    service_token_hash: Optional[StrictStr] = Field(default=None, alias="serviceTokenHash")
    service_access: Optional[StrictStr] = Field(default=None, alias="serviceAccess")
    service_access_hash: Optional[StrictStr] = Field(default=None, alias="serviceAccessHash")
    service_cert: Optional[StrictStr] = Field(default=None, alias="serviceCert")
    service_cert_hash: Optional[StrictStr] = Field(default=None, alias="serviceCertHash")
    service_version: Optional[StrictStr] = Field(default=None, alias="serviceVersion")
    search_domains: Optional[StrictStr] = Field(default=None, alias="searchDomains")
    enable_internal_dns: Optional[StrictBool] = Field(default=None, alias="enableInternalDns")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    datacenter_id: Optional[StrictStr] = Field(default=None, alias="datacenterId")
    status: Optional[StrictStr] = None
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    inventory_level: Optional[StrictStr] = Field(default=None, alias="inventoryLevel")
    last_sync: Optional[datetime] = Field(default=None, alias="lastSync")
    next_run_date: Optional[datetime] = Field(default=None, alias="nextRunDate")
    last_sync_duration: Optional[StrictInt] = Field(default=None, alias="lastSyncDuration")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    managed: Optional[StrictBool] = None
    labels: Optional[List[StrictStr]] = None
    auto_recover_power_state: Optional[StrictBool] = Field(default=None, alias="autoRecoverPowerState")
    service_entry: Optional[StrictStr] = Field(default=None, alias="serviceEntry")
    created_by: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = Field(default=None, alias="createdBy")
    user_group: Optional[StrictStr] = Field(default=None, alias="userGroup")
    layout: Optional[ListClusters200ResponseAllOfClustersInnerLayout] = None
    owner: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    servers: Optional[List[ListClusters200ResponseAllOfClustersInnerServersInner]] = None
    accounts: Optional[List[Dict[str, Any]]] = None
    integrations: Optional[List[Dict[str, Any]]] = None
    site: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    type: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    zone: Optional[ListClusters200ResponseAllOfClustersInnerZone] = None
    worker_stats: Optional[ListClusters200ResponseAllOfClustersInnerWorkerStats] = Field(default=None, alias="workerStats")
    config: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "code", "category", "visibility", "description", "location", "enabled", "serviceUrl", "serviceHost", "servicePath", "serviceHostname", "servicePort", "serviceUsername", "servicePassword", "servicePasswordHash", "serviceToken", "serviceTokenHash", "serviceAccess", "serviceAccessHash", "serviceCert", "serviceCertHash", "serviceVersion", "searchDomains", "enableInternalDns", "internalId", "externalId", "datacenterId", "status", "statusDate", "statusMessage", "inventoryLevel", "lastSync", "nextRunDate", "lastSyncDuration", "dateCreated", "lastUpdated", "managed", "labels", "autoRecoverPowerState", "serviceEntry", "createdBy", "userGroup", "layout", "owner", "servers", "accounts", "integrations", "site", "type", "zone", "workerStats", "config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClusters200ResponseAllOfClustersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of layout
        if self.layout:
            _dict['layout'] = self.layout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in servers (list)
        _items = []
        if self.servers:
            for _item_servers in self.servers:
                if _item_servers:
                    _items.append(_item_servers.to_dict())
            _dict['servers'] = _items
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict['site'] = self.site.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of worker_stats
        if self.worker_stats:
            _dict['workerStats'] = self.worker_stats.to_dict()
        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if service_url (nullable) is None
        # and model_fields_set contains the field
        if self.service_url is None and "service_url" in self.model_fields_set:
            _dict['serviceUrl'] = None

        # set to None if service_host (nullable) is None
        # and model_fields_set contains the field
        if self.service_host is None and "service_host" in self.model_fields_set:
            _dict['serviceHost'] = None

        # set to None if service_path (nullable) is None
        # and model_fields_set contains the field
        if self.service_path is None and "service_path" in self.model_fields_set:
            _dict['servicePath'] = None

        # set to None if service_hostname (nullable) is None
        # and model_fields_set contains the field
        if self.service_hostname is None and "service_hostname" in self.model_fields_set:
            _dict['serviceHostname'] = None

        # set to None if service_username (nullable) is None
        # and model_fields_set contains the field
        if self.service_username is None and "service_username" in self.model_fields_set:
            _dict['serviceUsername'] = None

        # set to None if service_password (nullable) is None
        # and model_fields_set contains the field
        if self.service_password is None and "service_password" in self.model_fields_set:
            _dict['servicePassword'] = None

        # set to None if service_password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.service_password_hash is None and "service_password_hash" in self.model_fields_set:
            _dict['servicePasswordHash'] = None

        # set to None if service_cert (nullable) is None
        # and model_fields_set contains the field
        if self.service_cert is None and "service_cert" in self.model_fields_set:
            _dict['serviceCert'] = None

        # set to None if service_cert_hash (nullable) is None
        # and model_fields_set contains the field
        if self.service_cert_hash is None and "service_cert_hash" in self.model_fields_set:
            _dict['serviceCertHash'] = None

        # set to None if search_domains (nullable) is None
        # and model_fields_set contains the field
        if self.search_domains is None and "search_domains" in self.model_fields_set:
            _dict['searchDomains'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if datacenter_id (nullable) is None
        # and model_fields_set contains the field
        if self.datacenter_id is None and "datacenter_id" in self.model_fields_set:
            _dict['datacenterId'] = None

        # set to None if service_entry (nullable) is None
        # and model_fields_set contains the field
        if self.service_entry is None and "service_entry" in self.model_fields_set:
            _dict['serviceEntry'] = None

        # set to None if user_group (nullable) is None
        # and model_fields_set contains the field
        if self.user_group is None and "user_group" in self.model_fields_set:
            _dict['userGroup'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClusters200ResponseAllOfClustersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "category": obj.get("category"),
            "visibility": obj.get("visibility"),
            "description": obj.get("description"),
            "location": obj.get("location"),
            "enabled": obj.get("enabled"),
            "serviceUrl": obj.get("serviceUrl"),
            "serviceHost": obj.get("serviceHost"),
            "servicePath": obj.get("servicePath"),
            "serviceHostname": obj.get("serviceHostname"),
            "servicePort": obj.get("servicePort"),
            "serviceUsername": obj.get("serviceUsername"),
            "servicePassword": obj.get("servicePassword"),
            "servicePasswordHash": obj.get("servicePasswordHash"),
            "serviceToken": obj.get("serviceToken"),
            "serviceTokenHash": obj.get("serviceTokenHash"),
            "serviceAccess": obj.get("serviceAccess"),
            "serviceAccessHash": obj.get("serviceAccessHash"),
            "serviceCert": obj.get("serviceCert"),
            "serviceCertHash": obj.get("serviceCertHash"),
            "serviceVersion": obj.get("serviceVersion"),
            "searchDomains": obj.get("searchDomains"),
            "enableInternalDns": obj.get("enableInternalDns"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "datacenterId": obj.get("datacenterId"),
            "status": obj.get("status"),
            "statusDate": obj.get("statusDate"),
            "statusMessage": obj.get("statusMessage"),
            "inventoryLevel": obj.get("inventoryLevel"),
            "lastSync": obj.get("lastSync"),
            "nextRunDate": obj.get("nextRunDate"),
            "lastSyncDuration": obj.get("lastSyncDuration"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "managed": obj.get("managed"),
            "labels": obj.get("labels"),
            "autoRecoverPowerState": obj.get("autoRecoverPowerState"),
            "serviceEntry": obj.get("serviceEntry"),
            "createdBy": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "userGroup": obj.get("userGroup"),
            "layout": ListClusters200ResponseAllOfClustersInnerLayout.from_dict(obj["layout"]) if obj.get("layout") is not None else None,
            "owner": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "servers": [ListClusters200ResponseAllOfClustersInnerServersInner.from_dict(_item) for _item in obj["servers"]] if obj.get("servers") is not None else None,
            "accounts": obj.get("accounts"),
            "integrations": obj.get("integrations"),
            "site": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["site"]) if obj.get("site") is not None else None,
            "type": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "zone": ListClusters200ResponseAllOfClustersInnerZone.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "workerStats": ListClusters200ResponseAllOfClustersInnerWorkerStats.from_dict(obj["workerStats"]) if obj.get("workerStats") is not None else None,
            "config": obj.get("config")
        })
        return _obj


