# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1ConfigServicesAzureVmsPaymentOptionsValueTermOptionsValueSummary(BaseModel):
    """
    ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1ConfigServicesAzureVmsPaymentOptionsValueTermOptionsValueSummary
    """ # noqa: E501
    total_savings: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalSavings")
    currency_code: Optional[StrictStr] = Field(default=None, alias="currencyCode")
    total_savings_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalSavingsPercent")
    term: Optional[StrictStr] = None
    payment_option: Optional[StrictStr] = Field(default=None, alias="paymentOption")
    service: Optional[StrictStr] = None
    on_demand_count: Optional[StrictInt] = Field(default=None, alias="onDemandCount")
    on_demand_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="onDemandCost")
    reserved_count: Optional[StrictInt] = Field(default=None, alias="reservedCount")
    reserved_cost: Optional[StrictInt] = Field(default=None, alias="reservedCost")
    recommended_count: Optional[StrictInt] = Field(default=None, alias="recommendedCount")
    recommended_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="recommendedCost")
    __properties: ClassVar[List[str]] = ["totalSavings", "currencyCode", "totalSavingsPercent", "term", "paymentOption", "service", "onDemandCount", "onDemandCost", "reservedCount", "reservedCost", "recommendedCount", "recommendedCost"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1ConfigServicesAzureVmsPaymentOptionsValueTermOptionsValueSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListGuidances200ResponseAllOfDiscoveriesInnerAnyOf1ConfigServicesAzureVmsPaymentOptionsValueTermOptionsValueSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "totalSavings": obj.get("totalSavings"),
            "currencyCode": obj.get("currencyCode"),
            "totalSavingsPercent": obj.get("totalSavingsPercent"),
            "term": obj.get("term"),
            "paymentOption": obj.get("paymentOption"),
            "service": obj.get("service"),
            "onDemandCount": obj.get("onDemandCount"),
            "onDemandCost": obj.get("onDemandCost"),
            "reservedCount": obj.get("reservedCount"),
            "reservedCost": obj.get("reservedCost"),
            "recommendedCount": obj.get("recommendedCount"),
            "recommendedCost": obj.get("recommendedCost")
        })
        return _obj


