# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_health200_response_all_of_health_threads_busy_threads_inner import ListHealth200ResponseAllOfHealthThreadsBusyThreadsInner
from typing import Optional, Set
from typing_extensions import Self

class ListHealth200ResponseAllOfHealthThreads(BaseModel):
    """
    ListHealth200ResponseAllOfHealthThreads
    """ # noqa: E501
    success: Optional[StrictBool] = None
    thread_list: Optional[List[Dict[str, Any]]] = Field(default=None, alias="threadList")
    busy_threads: Optional[List[ListHealth200ResponseAllOfHealthThreadsBusyThreadsInner]] = Field(default=None, alias="busyThreads")
    blocked_threads: Optional[List[Dict[str, Any]]] = Field(default=None, alias="blockedThreads")
    running_threads: Optional[List[Dict[str, Any]]] = Field(default=None, alias="runningThreads")
    total_cpu_time: Optional[StrictInt] = Field(default=None, alias="totalCpuTime")
    total_threads: Optional[StrictInt] = Field(default=None, alias="totalThreads")
    running_web_threads: Optional[StrictInt] = Field(default=None, alias="runningWebThreads")
    status: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["success", "threadList", "busyThreads", "blockedThreads", "runningThreads", "totalCpuTime", "totalThreads", "runningWebThreads", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthThreads from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in busy_threads (list)
        _items = []
        if self.busy_threads:
            for _item_busy_threads in self.busy_threads:
                if _item_busy_threads:
                    _items.append(_item_busy_threads.to_dict())
            _dict['busyThreads'] = _items
        # set to None if thread_list (nullable) is None
        # and model_fields_set contains the field
        if self.thread_list is None and "thread_list" in self.model_fields_set:
            _dict['threadList'] = None

        # set to None if blocked_threads (nullable) is None
        # and model_fields_set contains the field
        if self.blocked_threads is None and "blocked_threads" in self.model_fields_set:
            _dict['blockedThreads'] = None

        # set to None if running_threads (nullable) is None
        # and model_fields_set contains the field
        if self.running_threads is None and "running_threads" in self.model_fields_set:
            _dict['runningThreads'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthThreads from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "success": obj.get("success"),
            "threadList": obj.get("threadList"),
            "busyThreads": [ListHealth200ResponseAllOfHealthThreadsBusyThreadsInner.from_dict(_item) for _item in obj["busyThreads"]] if obj.get("busyThreads") is not None else None,
            "blockedThreads": obj.get("blockedThreads"),
            "runningThreads": obj.get("runningThreads"),
            "totalCpuTime": obj.get("totalCpuTime"),
            "totalThreads": obj.get("totalThreads"),
            "runningWebThreads": obj.get("runningWebThreads"),
            "status": obj.get("status")
        })
        return _obj


