# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_config_config import ListImageBuilds200ResponseAllOfImageBuildsInnerConfigConfig
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_config_instance import ListImageBuilds200ResponseAllOfImageBuildsInnerConfigInstance
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_config_network_interfaces_inner import ListImageBuilds200ResponseAllOfImageBuildsInnerConfigNetworkInterfacesInner
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_config_plan import ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_config_volumes_inner import ListImageBuilds200ResponseAllOfImageBuildsInnerConfigVolumesInner
from typing import Optional, Set
from typing_extensions import Self

class ListImageBuilds200ResponseAllOfImageBuildsInnerConfig(BaseModel):
    """
    ListImageBuilds200ResponseAllOfImageBuildsInnerConfig
    """ # noqa: E501
    instance: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerConfigInstance] = None
    network_interfaces: Optional[List[ListImageBuilds200ResponseAllOfImageBuildsInnerConfigNetworkInterfacesInner]] = Field(default=None, alias="networkInterfaces")
    volumes: Optional[List[ListImageBuilds200ResponseAllOfImageBuildsInnerConfigVolumesInner]] = None
    storage_controllers: Optional[List[Dict[str, Any]]] = Field(default=None, alias="storageControllers")
    zone_id: Optional[StrictInt] = Field(default=None, alias="zoneId")
    config: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerConfigConfig] = None
    plan: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan] = None
    __properties: ClassVar[List[str]] = ["instance", "networkInterfaces", "volumes", "storageControllers", "zoneId", "config", "plan"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListImageBuilds200ResponseAllOfImageBuildsInnerConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of instance
        if self.instance:
            _dict['instance'] = self.instance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in network_interfaces (list)
        _items = []
        if self.network_interfaces:
            for _item_network_interfaces in self.network_interfaces:
                if _item_network_interfaces:
                    _items.append(_item_network_interfaces.to_dict())
            _dict['networkInterfaces'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plan
        if self.plan:
            _dict['plan'] = self.plan.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListImageBuilds200ResponseAllOfImageBuildsInnerConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "instance": ListImageBuilds200ResponseAllOfImageBuildsInnerConfigInstance.from_dict(obj["instance"]) if obj.get("instance") is not None else None,
            "networkInterfaces": [ListImageBuilds200ResponseAllOfImageBuildsInnerConfigNetworkInterfacesInner.from_dict(_item) for _item in obj["networkInterfaces"]] if obj.get("networkInterfaces") is not None else None,
            "volumes": [ListImageBuilds200ResponseAllOfImageBuildsInnerConfigVolumesInner.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None,
            "storageControllers": obj.get("storageControllers"),
            "zoneId": obj.get("zoneId"),
            "config": ListImageBuilds200ResponseAllOfImageBuildsInnerConfigConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "plan": ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan.from_dict(obj["plan"]) if obj.get("plan") is not None else None
        })
        return _obj


