# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner_config_plan import ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan
from morpheus.models.list_instances200_response_all_of_instances_inner_config_backup import ListInstances200ResponseAllOfInstancesInnerConfigBackup
from morpheus.models.list_instances200_response_all_of_instances_inner_config_instance_type import ListInstances200ResponseAllOfInstancesInnerConfigInstanceType
from morpheus.models.list_instances200_response_all_of_instances_inner_config_no_agent import ListInstances200ResponseAllOfInstancesInnerConfigNoAgent
from morpheus.models.list_instances200_response_all_of_instances_inner_config_replication_group import ListInstances200ResponseAllOfInstancesInnerConfigReplicationGroup
from morpheus.models.list_instances200_response_all_of_instances_inner_config_resource_pool_id import ListInstances200ResponseAllOfInstancesInnerConfigResourcePoolId
from morpheus.models.list_instances200_response_all_of_instances_inner_config_security_groups_inner import ListInstances200ResponseAllOfInstancesInnerConfigSecurityGroupsInner
from morpheus.models.list_instances200_response_all_of_instances_inner_config_user_group import ListInstances200ResponseAllOfInstancesInnerConfigUserGroup
from typing import Optional, Set
from typing_extensions import Self

class ListInstances200ResponseAllOfInstancesInnerConfig(BaseModel):
    """
    ListInstances200ResponseAllOfInstancesInnerConfig
    """ # noqa: E501
    create_user: Optional[StrictBool] = Field(default=None, alias="createUser")
    is_ec2: Optional[StrictBool] = Field(default=None, alias="isEC2")
    is_vpc_selectable: Optional[StrictBool] = Field(default=None, alias="isVpcSelectable")
    no_agent: Optional[ListInstances200ResponseAllOfInstancesInnerConfigNoAgent] = Field(default=None, alias="noAgent")
    security_groups: Optional[List[ListInstances200ResponseAllOfInstancesInnerConfigSecurityGroupsInner]] = Field(default=None, alias="securityGroups")
    smbios_asset_tag: Optional[StrictStr] = Field(default=None, alias="smbiosAssetTag")
    nested_virtualization: Optional[StrictStr] = Field(default=None, alias="nestedVirtualization")
    vmware_folder_id: Optional[StrictStr] = Field(default=None, alias="vmwareFolderId")
    custom_options: Optional[Dict[str, Any]] = Field(default=None, alias="customOptions")
    resource_pool_id: Optional[ListInstances200ResponseAllOfInstancesInnerConfigResourcePoolId] = Field(default=None, alias="resourcePoolId")
    pool_provider_type: Optional[StrictStr] = Field(default=None, alias="poolProviderType")
    user_group: Optional[ListInstances200ResponseAllOfInstancesInnerConfigUserGroup] = Field(default=None, alias="userGroup")
    expire_days: Optional[StrictStr] = Field(default=None, alias="expireDays")
    shutdown_days: Optional[StrictStr] = Field(default=None, alias="shutdownDays")
    name: Optional[StrictStr] = None
    host_name: Optional[StrictStr] = Field(default=None, alias="hostName")
    instance_type: Optional[ListInstances200ResponseAllOfInstancesInnerConfigInstanceType] = Field(default=None, alias="instanceType")
    site: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    environment_prefix: Optional[StrictStr] = Field(default=None, alias="environmentPrefix")
    layout: Optional[ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan] = None
    type: Optional[StrictStr] = None
    instance_context: Optional[StrictStr] = Field(default=None, alias="instanceContext")
    memory_display: Optional[StrictStr] = Field(default=None, alias="memoryDisplay")
    expose: Optional[List[Dict[str, Any]]] = None
    create_backup: Optional[StrictBool] = Field(default=None, alias="createBackup")
    backup: Optional[ListInstances200ResponseAllOfInstancesInnerConfigBackup] = None
    replication_group: Optional[ListInstances200ResponseAllOfInstancesInnerConfigReplicationGroup] = Field(default=None, alias="replicationGroup")
    layout_size: Optional[StrictInt] = Field(default=None, alias="layoutSize")
    lb_instances: Optional[List[Dict[str, Any]]] = Field(default=None, alias="lbInstances")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["createUser", "isEC2", "isVpcSelectable", "noAgent", "securityGroups", "smbiosAssetTag", "nestedVirtualization", "vmwareFolderId", "customOptions", "resourcePoolId", "poolProviderType", "userGroup", "expireDays", "shutdownDays", "name", "hostName", "instanceType", "site", "environmentPrefix", "layout", "type", "instanceContext", "memoryDisplay", "expose", "createBackup", "backup", "replicationGroup", "layoutSize", "lbInstances"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListInstances200ResponseAllOfInstancesInnerConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of no_agent
        if self.no_agent:
            _dict['noAgent'] = self.no_agent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in security_groups (list)
        _items = []
        if self.security_groups:
            for _item_security_groups in self.security_groups:
                if _item_security_groups:
                    _items.append(_item_security_groups.to_dict())
            _dict['securityGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_pool_id
        if self.resource_pool_id:
            _dict['resourcePoolId'] = self.resource_pool_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_group
        if self.user_group:
            _dict['userGroup'] = self.user_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instance_type
        if self.instance_type:
            _dict['instanceType'] = self.instance_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict['site'] = self.site.to_dict()
        # override the default output from pydantic by calling `to_dict()` of layout
        if self.layout:
            _dict['layout'] = self.layout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of backup
        if self.backup:
            _dict['backup'] = self.backup.to_dict()
        # override the default output from pydantic by calling `to_dict()` of replication_group
        if self.replication_group:
            _dict['replicationGroup'] = self.replication_group.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if smbios_asset_tag (nullable) is None
        # and model_fields_set contains the field
        if self.smbios_asset_tag is None and "smbios_asset_tag" in self.model_fields_set:
            _dict['smbiosAssetTag'] = None

        # set to None if nested_virtualization (nullable) is None
        # and model_fields_set contains the field
        if self.nested_virtualization is None and "nested_virtualization" in self.model_fields_set:
            _dict['nestedVirtualization'] = None

        # set to None if pool_provider_type (nullable) is None
        # and model_fields_set contains the field
        if self.pool_provider_type is None and "pool_provider_type" in self.model_fields_set:
            _dict['poolProviderType'] = None

        # set to None if environment_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.environment_prefix is None and "environment_prefix" in self.model_fields_set:
            _dict['environmentPrefix'] = None

        # set to None if expose (nullable) is None
        # and model_fields_set contains the field
        if self.expose is None and "expose" in self.model_fields_set:
            _dict['expose'] = None

        # set to None if lb_instances (nullable) is None
        # and model_fields_set contains the field
        if self.lb_instances is None and "lb_instances" in self.model_fields_set:
            _dict['lbInstances'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListInstances200ResponseAllOfInstancesInnerConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createUser": obj.get("createUser"),
            "isEC2": obj.get("isEC2"),
            "isVpcSelectable": obj.get("isVpcSelectable"),
            "noAgent": ListInstances200ResponseAllOfInstancesInnerConfigNoAgent.from_dict(obj["noAgent"]) if obj.get("noAgent") is not None else None,
            "securityGroups": [ListInstances200ResponseAllOfInstancesInnerConfigSecurityGroupsInner.from_dict(_item) for _item in obj["securityGroups"]] if obj.get("securityGroups") is not None else None,
            "smbiosAssetTag": obj.get("smbiosAssetTag"),
            "nestedVirtualization": obj.get("nestedVirtualization"),
            "vmwareFolderId": obj.get("vmwareFolderId"),
            "customOptions": obj.get("customOptions"),
            "resourcePoolId": ListInstances200ResponseAllOfInstancesInnerConfigResourcePoolId.from_dict(obj["resourcePoolId"]) if obj.get("resourcePoolId") is not None else None,
            "poolProviderType": obj.get("poolProviderType"),
            "userGroup": ListInstances200ResponseAllOfInstancesInnerConfigUserGroup.from_dict(obj["userGroup"]) if obj.get("userGroup") is not None else None,
            "expireDays": obj.get("expireDays"),
            "shutdownDays": obj.get("shutdownDays"),
            "name": obj.get("name"),
            "hostName": obj.get("hostName"),
            "instanceType": ListInstances200ResponseAllOfInstancesInnerConfigInstanceType.from_dict(obj["instanceType"]) if obj.get("instanceType") is not None else None,
            "site": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["site"]) if obj.get("site") is not None else None,
            "environmentPrefix": obj.get("environmentPrefix"),
            "layout": ListImageBuilds200ResponseAllOfImageBuildsInnerConfigPlan.from_dict(obj["layout"]) if obj.get("layout") is not None else None,
            "type": obj.get("type"),
            "instanceContext": obj.get("instanceContext"),
            "memoryDisplay": obj.get("memoryDisplay"),
            "expose": obj.get("expose"),
            "createBackup": obj.get("createBackup"),
            "backup": ListInstances200ResponseAllOfInstancesInnerConfigBackup.from_dict(obj["backup"]) if obj.get("backup") is not None else None,
            "replicationGroup": ListInstances200ResponseAllOfInstancesInnerConfigReplicationGroup.from_dict(obj["replicationGroup"]) if obj.get("replicationGroup") is not None else None,
            "layoutSize": obj.get("layoutSize"),
            "lbInstances": obj.get("lbInstances")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


