# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from typing import Optional, Set
from typing_extensions import Self

class ListInstances200ResponseAllOfInstancesInnerInterfacesInnerNetwork(BaseModel):
    """
    ListInstances200ResponseAllOfInstancesInnerInterfacesInnerNetwork
    """ # noqa: E501
    id: Optional[StrictInt] = None
    group: Optional[StrictInt] = None
    subnet: Optional[StrictStr] = None
    dhcp_server: Optional[StrictBool] = Field(default=None, alias="dhcpServer")
    name: Optional[StrictStr] = None
    pool: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    __properties: ClassVar[List[str]] = ["id", "group", "subnet", "dhcpServer", "name", "pool"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListInstances200ResponseAllOfInstancesInnerInterfacesInnerNetwork from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pool
        if self.pool:
            _dict['pool'] = self.pool.to_dict()
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if group (nullable) is None
        # and model_fields_set contains the field
        if self.group is None and "group" in self.model_fields_set:
            _dict['group'] = None

        # set to None if subnet (nullable) is None
        # and model_fields_set contains the field
        if self.subnet is None and "subnet" in self.model_fields_set:
            _dict['subnet'] = None

        # set to None if dhcp_server (nullable) is None
        # and model_fields_set contains the field
        if self.dhcp_server is None and "dhcp_server" in self.model_fields_set:
            _dict['dhcpServer'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListInstances200ResponseAllOfInstancesInnerInterfacesInnerNetwork from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "group": obj.get("group"),
            "subnet": obj.get("subnet"),
            "dhcpServer": obj.get("dhcpServer"),
            "name": obj.get("name"),
            "pool": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["pool"]) if obj.get("pool") is not None else None
        })
        return _obj


