# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from morpheus.models.list_integrations200_response_any_of import ListIntegrations200ResponseAnyOf
from morpheus.models.list_integrations200_response_any_of1 import ListIntegrations200ResponseAnyOf1
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

LISTINTEGRATIONS200RESPONSE_ANY_OF_SCHEMAS = ["ListIntegrations200ResponseAnyOf", "ListIntegrations200ResponseAnyOf1"]

class ListIntegrations200Response(BaseModel):
    """
    ListIntegrations200Response
    """

    # data type: ListIntegrations200ResponseAnyOf
    anyof_schema_1_validator: Optional[ListIntegrations200ResponseAnyOf] = None
    # data type: ListIntegrations200ResponseAnyOf1
    anyof_schema_2_validator: Optional[ListIntegrations200ResponseAnyOf1] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[ListIntegrations200ResponseAnyOf, ListIntegrations200ResponseAnyOf1]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "ListIntegrations200ResponseAnyOf", "ListIntegrations200ResponseAnyOf1" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = ListIntegrations200Response.model_construct()
        error_messages = []
        # validate data type: ListIntegrations200ResponseAnyOf
        if not isinstance(v, ListIntegrations200ResponseAnyOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ListIntegrations200ResponseAnyOf`")
        else:
            return v

        # validate data type: ListIntegrations200ResponseAnyOf1
        if not isinstance(v, ListIntegrations200ResponseAnyOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ListIntegrations200ResponseAnyOf1`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in ListIntegrations200Response with anyOf schemas: ListIntegrations200ResponseAnyOf, ListIntegrations200ResponseAnyOf1. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[ListIntegrations200ResponseAnyOf] = None
        try:
            instance.actual_instance = ListIntegrations200ResponseAnyOf.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[ListIntegrations200ResponseAnyOf1] = None
        try:
            instance.actual_instance = ListIntegrations200ResponseAnyOf1.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ListIntegrations200Response with anyOf schemas: ListIntegrations200ResponseAnyOf, ListIntegrations200ResponseAnyOf1. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ListIntegrations200ResponseAnyOf, ListIntegrations200ResponseAnyOf1]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


