# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_integrations200_response_any_of_integrations_inner_any_of3_config_databags_inner import ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf3ConfigDatabagsInner
from typing import Optional, Set
from typing_extensions import Self

class ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf3Config(BaseModel):
    """
    ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf3Config
    """ # noqa: E501
    databags: Optional[List[ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf3ConfigDatabagsInner]] = None
    endpoint: Optional[StrictStr] = None
    org: Optional[StrictStr] = None
    chef_user: Optional[StrictStr] = Field(default=None, alias="chefUser")
    user_key: Optional[StrictStr] = Field(default=None, alias="userKey")
    org_key: Optional[StrictStr] = Field(default=None, alias="orgKey")
    version: Optional[StrictStr] = None
    chef_use_fqdn: Optional[StrictBool] = Field(default=None, alias="chefUseFqdn")
    windows_version: Optional[StrictStr] = Field(default=None, alias="windowsVersion")
    windows_install_url: Optional[StrictStr] = Field(default=None, alias="windowsInstallUrl")
    user_key_hash: Optional[StrictStr] = Field(default=None, alias="userKeyHash")
    org_key_hash: Optional[StrictStr] = Field(default=None, alias="orgKeyHash")
    __properties: ClassVar[List[str]] = ["databags", "endpoint", "org", "chefUser", "userKey", "orgKey", "version", "chefUseFqdn", "windowsVersion", "windowsInstallUrl", "userKeyHash", "orgKeyHash"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf3Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in databags (list)
        _items = []
        if self.databags:
            for _item_databags in self.databags:
                if _item_databags:
                    _items.append(_item_databags.to_dict())
            _dict['databags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf3Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "databags": [ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf3ConfigDatabagsInner.from_dict(_item) for _item in obj["databags"]] if obj.get("databags") is not None else None,
            "endpoint": obj.get("endpoint"),
            "org": obj.get("org"),
            "chefUser": obj.get("chefUser"),
            "userKey": obj.get("userKey"),
            "orgKey": obj.get("orgKey"),
            "version": obj.get("version"),
            "chefUseFqdn": obj.get("chefUseFqdn"),
            "windowsVersion": obj.get("windowsVersion"),
            "windowsInstallUrl": obj.get("windowsInstallUrl"),
            "userKeyHash": obj.get("userKeyHash"),
            "orgKeyHash": obj.get("orgKeyHash")
        })
        return _obj


