# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_networks200_response_all_of_networks_inner_config import ListNetworks200ResponseAllOfNetworksInnerConfig
from morpheus.models.list_networks200_response_all_of_networks_inner_network_domain import ListNetworks200ResponseAllOfNetworksInnerNetworkDomain
from morpheus.models.list_networks200_response_all_of_networks_inner_network_proxy import ListNetworks200ResponseAllOfNetworksInnerNetworkProxy
from morpheus.models.list_networks200_response_all_of_networks_inner_owner import ListNetworks200ResponseAllOfNetworksInnerOwner
from morpheus.models.list_networks200_response_all_of_networks_inner_type import ListNetworks200ResponseAllOfNetworksInnerType
from morpheus.models.list_networks200_response_all_of_networks_inner_zone import ListNetworks200ResponseAllOfNetworksInnerZone
from typing import Optional, Set
from typing_extensions import Self

class ListNetworks200ResponseAllOfNetworksInner(BaseModel):
    """
    ListNetworks200ResponseAllOfNetworksInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Network ID")
    name: Optional[StrictStr] = Field(default=None, description="Name")
    display_name: Optional[StrictStr] = Field(default=None, description="Network Display Name", alias="displayName")
    labels: Optional[List[StrictStr]] = None
    zone: Optional[ListNetworks200ResponseAllOfNetworksInnerZone] = None
    type: Optional[ListNetworks200ResponseAllOfNetworksInnerType] = None
    owner: Optional[ListNetworks200ResponseAllOfNetworksInnerOwner] = None
    code: Optional[StrictStr] = Field(default=None, description="Network Code")
    ipv4_enabled: Optional[StrictBool] = Field(default=None, alias="ipv4Enabled")
    ipv6_enabled: Optional[StrictBool] = Field(default=None, alias="ipv6Enabled")
    category: Optional[StrictStr] = Field(default=None, description="Network Category")
    interface_name: Optional[StrictStr] = Field(default=None, alias="interfaceName")
    bridge_name: Optional[StrictStr] = Field(default=None, alias="bridgeName")
    bridge_interface: Optional[StrictStr] = Field(default=None, alias="bridgeInterface")
    description: Optional[StrictStr] = Field(default=None, description="Description")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    unique_id: Optional[StrictStr] = Field(default=None, alias="uniqueId")
    external_type: Optional[StrictStr] = Field(default=None, alias="externalType")
    ref_url: Optional[StrictStr] = Field(default=None, alias="refUrl")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    vlan_id: Optional[StrictInt] = Field(default=None, alias="vlanId")
    vswitch_name: Optional[StrictStr] = Field(default=None, alias="vswitchName")
    dhcp_server: Optional[StrictBool] = Field(default=None, alias="dhcpServer")
    dhcp_ip: Optional[StrictStr] = Field(default=None, alias="dhcpIp")
    dhcp_server_ipv6: Optional[StrictBool] = Field(default=None, alias="dhcpServerIPv6")
    gateway: Optional[StrictStr] = Field(default=None, description="Network Gateway")
    netmask: Optional[StrictStr] = None
    broadcast: Optional[StrictStr] = None
    subnet_address: Optional[StrictStr] = Field(default=None, alias="subnetAddress")
    dns_primary: Optional[StrictStr] = Field(default=None, description="Primary DNS Server", alias="dnsPrimary")
    dns_secondary: Optional[StrictStr] = Field(default=None, description="Secondary DNS Server", alias="dnsSecondary")
    cidr: Optional[StrictStr] = Field(default=None, description="Network CIDR")
    gateway_ipv6: Optional[StrictStr] = Field(default=None, description="IPv6 Network Gateway", alias="gatewayIPv6")
    netmask_ipv6: Optional[StrictStr] = Field(default=None, alias="netmaskIPv6")
    dns_primary_ipv6: Optional[StrictStr] = Field(default=None, description="Primary IPv6 DNS Server", alias="dnsPrimaryIPv6")
    dns_secondary_ipv6: Optional[StrictStr] = Field(default=None, description="Secondary IPv6 DNS Server", alias="dnsSecondaryIPv6")
    cidr_ipv6: Optional[StrictStr] = Field(default=None, description="IPv6 Network CIDR", alias="cidrIPv6")
    tftp_server: Optional[StrictStr] = Field(default=None, alias="tftpServer")
    boot_file: Optional[StrictStr] = Field(default=None, alias="bootFile")
    switch_id: Optional[StrictStr] = Field(default=None, alias="switchId")
    fabric_id: Optional[StrictStr] = Field(default=None, alias="fabricId")
    network_role: Optional[StrictStr] = Field(default=None, alias="networkRole")
    status: Optional[StrictStr] = None
    availability_zone: Optional[StrictStr] = Field(default=None, alias="availabilityZone")
    pool: Optional[Dict[str, Any]] = None
    pool_ipv6: Optional[Dict[str, Any]] = Field(default=None, alias="poolIPv6")
    network_proxy: Optional[ListNetworks200ResponseAllOfNetworksInnerNetworkProxy] = Field(default=None, alias="networkProxy")
    network_domain: Optional[ListNetworks200ResponseAllOfNetworksInnerNetworkDomain] = Field(default=None, alias="networkDomain")
    search_domains: Optional[StrictStr] = Field(default=None, alias="searchDomains")
    prefix_length: Optional[StrictStr] = Field(default=None, alias="prefixLength")
    visibility: Optional[StrictStr] = None
    enable_admin: Optional[StrictBool] = Field(default=None, alias="enableAdmin")
    active: Optional[StrictBool] = None
    default_network: Optional[StrictBool] = Field(default=None, alias="defaultNetwork")
    assign_public_ip: Optional[StrictBool] = Field(default=None, alias="assignPublicIp")
    no_proxy: Optional[StrictStr] = Field(default=None, alias="noProxy")
    appliance_url_proxy_bypass: Optional[StrictBool] = Field(default=None, alias="applianceUrlProxyBypass")
    zone_pool: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="zonePool")
    allow_static_override: Optional[StrictBool] = Field(default=None, alias="allowStaticOverride")
    config: Optional[ListNetworks200ResponseAllOfNetworksInnerConfig] = None
    tenants: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "displayName", "labels", "zone", "type", "owner", "code", "ipv4Enabled", "ipv6Enabled", "category", "interfaceName", "bridgeName", "bridgeInterface", "description", "externalId", "internalId", "uniqueId", "externalType", "refUrl", "refType", "refId", "vlanId", "vswitchName", "dhcpServer", "dhcpIp", "dhcpServerIPv6", "gateway", "netmask", "broadcast", "subnetAddress", "dnsPrimary", "dnsSecondary", "cidr", "gatewayIPv6", "netmaskIPv6", "dnsPrimaryIPv6", "dnsSecondaryIPv6", "cidrIPv6", "tftpServer", "bootFile", "switchId", "fabricId", "networkRole", "status", "availabilityZone", "pool", "poolIPv6", "networkProxy", "networkDomain", "searchDomains", "prefixLength", "visibility", "enableAdmin", "active", "defaultNetwork", "assignPublicIp", "noProxy", "applianceUrlProxyBypass", "zonePool", "allowStaticOverride", "config", "tenants"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListNetworks200ResponseAllOfNetworksInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_proxy
        if self.network_proxy:
            _dict['networkProxy'] = self.network_proxy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_domain
        if self.network_domain:
            _dict['networkDomain'] = self.network_domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone_pool
        if self.zone_pool:
            _dict['zonePool'] = self.zone_pool.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if interface_name (nullable) is None
        # and model_fields_set contains the field
        if self.interface_name is None and "interface_name" in self.model_fields_set:
            _dict['interfaceName'] = None

        # set to None if bridge_name (nullable) is None
        # and model_fields_set contains the field
        if self.bridge_name is None and "bridge_name" in self.model_fields_set:
            _dict['bridgeName'] = None

        # set to None if bridge_interface (nullable) is None
        # and model_fields_set contains the field
        if self.bridge_interface is None and "bridge_interface" in self.model_fields_set:
            _dict['bridgeInterface'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.unique_id is None and "unique_id" in self.model_fields_set:
            _dict['uniqueId'] = None

        # set to None if ref_url (nullable) is None
        # and model_fields_set contains the field
        if self.ref_url is None and "ref_url" in self.model_fields_set:
            _dict['refUrl'] = None

        # set to None if vlan_id (nullable) is None
        # and model_fields_set contains the field
        if self.vlan_id is None and "vlan_id" in self.model_fields_set:
            _dict['vlanId'] = None

        # set to None if vswitch_name (nullable) is None
        # and model_fields_set contains the field
        if self.vswitch_name is None and "vswitch_name" in self.model_fields_set:
            _dict['vswitchName'] = None

        # set to None if dhcp_ip (nullable) is None
        # and model_fields_set contains the field
        if self.dhcp_ip is None and "dhcp_ip" in self.model_fields_set:
            _dict['dhcpIp'] = None

        # set to None if gateway (nullable) is None
        # and model_fields_set contains the field
        if self.gateway is None and "gateway" in self.model_fields_set:
            _dict['gateway'] = None

        # set to None if netmask (nullable) is None
        # and model_fields_set contains the field
        if self.netmask is None and "netmask" in self.model_fields_set:
            _dict['netmask'] = None

        # set to None if broadcast (nullable) is None
        # and model_fields_set contains the field
        if self.broadcast is None and "broadcast" in self.model_fields_set:
            _dict['broadcast'] = None

        # set to None if subnet_address (nullable) is None
        # and model_fields_set contains the field
        if self.subnet_address is None and "subnet_address" in self.model_fields_set:
            _dict['subnetAddress'] = None

        # set to None if dns_primary (nullable) is None
        # and model_fields_set contains the field
        if self.dns_primary is None and "dns_primary" in self.model_fields_set:
            _dict['dnsPrimary'] = None

        # set to None if dns_secondary (nullable) is None
        # and model_fields_set contains the field
        if self.dns_secondary is None and "dns_secondary" in self.model_fields_set:
            _dict['dnsSecondary'] = None

        # set to None if gateway_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.gateway_ipv6 is None and "gateway_ipv6" in self.model_fields_set:
            _dict['gatewayIPv6'] = None

        # set to None if netmask_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.netmask_ipv6 is None and "netmask_ipv6" in self.model_fields_set:
            _dict['netmaskIPv6'] = None

        # set to None if dns_primary_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.dns_primary_ipv6 is None and "dns_primary_ipv6" in self.model_fields_set:
            _dict['dnsPrimaryIPv6'] = None

        # set to None if dns_secondary_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.dns_secondary_ipv6 is None and "dns_secondary_ipv6" in self.model_fields_set:
            _dict['dnsSecondaryIPv6'] = None

        # set to None if cidr_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.cidr_ipv6 is None and "cidr_ipv6" in self.model_fields_set:
            _dict['cidrIPv6'] = None

        # set to None if tftp_server (nullable) is None
        # and model_fields_set contains the field
        if self.tftp_server is None and "tftp_server" in self.model_fields_set:
            _dict['tftpServer'] = None

        # set to None if boot_file (nullable) is None
        # and model_fields_set contains the field
        if self.boot_file is None and "boot_file" in self.model_fields_set:
            _dict['bootFile'] = None

        # set to None if switch_id (nullable) is None
        # and model_fields_set contains the field
        if self.switch_id is None and "switch_id" in self.model_fields_set:
            _dict['switchId'] = None

        # set to None if fabric_id (nullable) is None
        # and model_fields_set contains the field
        if self.fabric_id is None and "fabric_id" in self.model_fields_set:
            _dict['fabricId'] = None

        # set to None if network_role (nullable) is None
        # and model_fields_set contains the field
        if self.network_role is None and "network_role" in self.model_fields_set:
            _dict['networkRole'] = None

        # set to None if availability_zone (nullable) is None
        # and model_fields_set contains the field
        if self.availability_zone is None and "availability_zone" in self.model_fields_set:
            _dict['availabilityZone'] = None

        # set to None if pool (nullable) is None
        # and model_fields_set contains the field
        if self.pool is None and "pool" in self.model_fields_set:
            _dict['pool'] = None

        # set to None if pool_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.pool_ipv6 is None and "pool_ipv6" in self.model_fields_set:
            _dict['poolIPv6'] = None

        # set to None if search_domains (nullable) is None
        # and model_fields_set contains the field
        if self.search_domains is None and "search_domains" in self.model_fields_set:
            _dict['searchDomains'] = None

        # set to None if prefix_length (nullable) is None
        # and model_fields_set contains the field
        if self.prefix_length is None and "prefix_length" in self.model_fields_set:
            _dict['prefixLength'] = None

        # set to None if no_proxy (nullable) is None
        # and model_fields_set contains the field
        if self.no_proxy is None and "no_proxy" in self.model_fields_set:
            _dict['noProxy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListNetworks200ResponseAllOfNetworksInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "displayName": obj.get("displayName"),
            "labels": obj.get("labels"),
            "zone": ListNetworks200ResponseAllOfNetworksInnerZone.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "type": ListNetworks200ResponseAllOfNetworksInnerType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "owner": ListNetworks200ResponseAllOfNetworksInnerOwner.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "code": obj.get("code"),
            "ipv4Enabled": obj.get("ipv4Enabled"),
            "ipv6Enabled": obj.get("ipv6Enabled"),
            "category": obj.get("category"),
            "interfaceName": obj.get("interfaceName"),
            "bridgeName": obj.get("bridgeName"),
            "bridgeInterface": obj.get("bridgeInterface"),
            "description": obj.get("description"),
            "externalId": obj.get("externalId"),
            "internalId": obj.get("internalId"),
            "uniqueId": obj.get("uniqueId"),
            "externalType": obj.get("externalType"),
            "refUrl": obj.get("refUrl"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "vlanId": obj.get("vlanId"),
            "vswitchName": obj.get("vswitchName"),
            "dhcpServer": obj.get("dhcpServer"),
            "dhcpIp": obj.get("dhcpIp"),
            "dhcpServerIPv6": obj.get("dhcpServerIPv6"),
            "gateway": obj.get("gateway"),
            "netmask": obj.get("netmask"),
            "broadcast": obj.get("broadcast"),
            "subnetAddress": obj.get("subnetAddress"),
            "dnsPrimary": obj.get("dnsPrimary"),
            "dnsSecondary": obj.get("dnsSecondary"),
            "cidr": obj.get("cidr"),
            "gatewayIPv6": obj.get("gatewayIPv6"),
            "netmaskIPv6": obj.get("netmaskIPv6"),
            "dnsPrimaryIPv6": obj.get("dnsPrimaryIPv6"),
            "dnsSecondaryIPv6": obj.get("dnsSecondaryIPv6"),
            "cidrIPv6": obj.get("cidrIPv6"),
            "tftpServer": obj.get("tftpServer"),
            "bootFile": obj.get("bootFile"),
            "switchId": obj.get("switchId"),
            "fabricId": obj.get("fabricId"),
            "networkRole": obj.get("networkRole"),
            "status": obj.get("status"),
            "availabilityZone": obj.get("availabilityZone"),
            "pool": obj.get("pool"),
            "poolIPv6": obj.get("poolIPv6"),
            "networkProxy": ListNetworks200ResponseAllOfNetworksInnerNetworkProxy.from_dict(obj["networkProxy"]) if obj.get("networkProxy") is not None else None,
            "networkDomain": ListNetworks200ResponseAllOfNetworksInnerNetworkDomain.from_dict(obj["networkDomain"]) if obj.get("networkDomain") is not None else None,
            "searchDomains": obj.get("searchDomains"),
            "prefixLength": obj.get("prefixLength"),
            "visibility": obj.get("visibility"),
            "enableAdmin": obj.get("enableAdmin"),
            "active": obj.get("active"),
            "defaultNetwork": obj.get("defaultNetwork"),
            "assignPublicIp": obj.get("assignPublicIp"),
            "noProxy": obj.get("noProxy"),
            "applianceUrlProxyBypass": obj.get("applianceUrlProxyBypass"),
            "zonePool": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["zonePool"]) if obj.get("zonePool") is not None else None,
            "allowStaticOverride": obj.get("allowStaticOverride"),
            "config": ListNetworks200ResponseAllOfNetworksInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "tenants": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None
        })
        return _obj


