# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class ListPriceSets200ResponseAllOfPriceSetsInnerPricesInner(BaseModel):
    """
    ListPriceSets200ResponseAllOfPriceSetsInnerPricesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    price_type: Optional[StrictStr] = Field(default=None, alias="priceType")
    price_unit: Optional[StrictStr] = Field(default=None, alias="priceUnit")
    additional_price_unit: Optional[StrictStr] = Field(default=None, alias="additionalPriceUnit")
    price: Optional[Union[StrictFloat, StrictInt]] = None
    custom_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="customPrice")
    markup_type: Optional[StrictStr] = Field(default=None, alias="markupType")
    markup: Optional[StrictInt] = None
    markup_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="markupPercent")
    cost: Optional[Union[StrictFloat, StrictInt]] = None
    currency: Optional[StrictStr] = None
    incur_charges: Optional[StrictStr] = Field(default=None, alias="incurCharges")
    platform: Optional[StrictStr] = None
    software: Optional[StrictStr] = None
    volume_type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="volumeType")
    datastore: Optional[StrictStr] = None
    cross_cloud_apply: Optional[StrictBool] = Field(default=None, alias="crossCloudApply")
    account: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "code", "active", "priceType", "priceUnit", "additionalPriceUnit", "price", "customPrice", "markupType", "markup", "markupPercent", "cost", "currency", "incurCharges", "platform", "software", "volumeType", "datastore", "crossCloudApply", "account"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListPriceSets200ResponseAllOfPriceSetsInnerPricesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of volume_type
        if self.volume_type:
            _dict['volumeType'] = self.volume_type.to_dict()
        # set to None if additional_price_unit (nullable) is None
        # and model_fields_set contains the field
        if self.additional_price_unit is None and "additional_price_unit" in self.model_fields_set:
            _dict['additionalPriceUnit'] = None

        # set to None if price (nullable) is None
        # and model_fields_set contains the field
        if self.price is None and "price" in self.model_fields_set:
            _dict['price'] = None

        # set to None if custom_price (nullable) is None
        # and model_fields_set contains the field
        if self.custom_price is None and "custom_price" in self.model_fields_set:
            _dict['customPrice'] = None

        # set to None if markup_type (nullable) is None
        # and model_fields_set contains the field
        if self.markup_type is None and "markup_type" in self.model_fields_set:
            _dict['markupType'] = None

        # set to None if markup_percent (nullable) is None
        # and model_fields_set contains the field
        if self.markup_percent is None and "markup_percent" in self.model_fields_set:
            _dict['markupPercent'] = None

        # set to None if cost (nullable) is None
        # and model_fields_set contains the field
        if self.cost is None and "cost" in self.model_fields_set:
            _dict['cost'] = None

        # set to None if currency (nullable) is None
        # and model_fields_set contains the field
        if self.currency is None and "currency" in self.model_fields_set:
            _dict['currency'] = None

        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        # set to None if software (nullable) is None
        # and model_fields_set contains the field
        if self.software is None and "software" in self.model_fields_set:
            _dict['software'] = None

        # set to None if datastore (nullable) is None
        # and model_fields_set contains the field
        if self.datastore is None and "datastore" in self.model_fields_set:
            _dict['datastore'] = None

        # set to None if cross_cloud_apply (nullable) is None
        # and model_fields_set contains the field
        if self.cross_cloud_apply is None and "cross_cloud_apply" in self.model_fields_set:
            _dict['crossCloudApply'] = None

        # set to None if account (nullable) is None
        # and model_fields_set contains the field
        if self.account is None and "account" in self.model_fields_set:
            _dict['account'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListPriceSets200ResponseAllOfPriceSetsInnerPricesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "active": obj.get("active"),
            "priceType": obj.get("priceType"),
            "priceUnit": obj.get("priceUnit"),
            "additionalPriceUnit": obj.get("additionalPriceUnit"),
            "price": obj.get("price"),
            "customPrice": obj.get("customPrice"),
            "markupType": obj.get("markupType"),
            "markup": obj.get("markup"),
            "markupPercent": obj.get("markupPercent"),
            "cost": obj.get("cost"),
            "currency": obj.get("currency"),
            "incurCharges": obj.get("incurCharges"),
            "platform": obj.get("platform"),
            "software": obj.get("software"),
            "volumeType": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["volumeType"]) if obj.get("volumeType") is not None else None,
            "datastore": obj.get("datastore"),
            "crossCloudApply": obj.get("crossCloudApply"),
            "account": obj.get("account")
        })
        return _obj


